package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceInstanceStatusBuilder extends ServiceInstanceStatusFluentImpl<ServiceInstanceStatusBuilder> implements VisitableBuilder<ServiceInstanceStatus,ServiceInstanceStatusBuilder>{
  public ServiceInstanceStatusBuilder() {
    this(false);
  }
  public ServiceInstanceStatusBuilder(Boolean validationEnabled) {
    this(new ServiceInstanceStatus(), validationEnabled);
  }
  public ServiceInstanceStatusBuilder(ServiceInstanceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceStatusBuilder(ServiceInstanceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceInstanceStatus(), validationEnabled);
  }
  public ServiceInstanceStatusBuilder(ServiceInstanceStatusFluent<?> fluent,ServiceInstanceStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceStatusBuilder(ServiceInstanceStatusFluent<?> fluent,ServiceInstanceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAsyncOpInProgress(instance.getAsyncOpInProgress()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withCurrentOperation(instance.getCurrentOperation()); 
    fluent.withDashboardURL(instance.getDashboardURL()); 
    fluent.withDefaultProvisionParameters(instance.getDefaultProvisionParameters()); 
    fluent.withDeprovisionStatus(instance.getDeprovisionStatus()); 
    fluent.withExternalProperties(instance.getExternalProperties()); 
    fluent.withInProgressProperties(instance.getInProgressProperties()); 
    fluent.withLastOperation(instance.getLastOperation()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withOperationStartTime(instance.getOperationStartTime()); 
    fluent.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress()); 
    fluent.withProvisionStatus(instance.getProvisionStatus()); 
    fluent.withReconciledGeneration(instance.getReconciledGeneration()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceStatusBuilder(ServiceInstanceStatus instance) {
    this(instance,false);
  }
  public ServiceInstanceStatusBuilder(ServiceInstanceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAsyncOpInProgress(instance.getAsyncOpInProgress()); 
    this.withConditions(instance.getConditions()); 
    this.withCurrentOperation(instance.getCurrentOperation()); 
    this.withDashboardURL(instance.getDashboardURL()); 
    this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters()); 
    this.withDeprovisionStatus(instance.getDeprovisionStatus()); 
    this.withExternalProperties(instance.getExternalProperties()); 
    this.withInProgressProperties(instance.getInProgressProperties()); 
    this.withLastOperation(instance.getLastOperation()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withOperationStartTime(instance.getOperationStartTime()); 
    this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress()); 
    this.withProvisionStatus(instance.getProvisionStatus()); 
    this.withReconciledGeneration(instance.getReconciledGeneration()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceInstanceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceInstanceStatus build() {
    ServiceInstanceStatus buildable = new ServiceInstanceStatus(fluent.getAsyncOpInProgress(),fluent.getConditions(),fluent.getCurrentOperation(),fluent.getDashboardURL(),fluent.getDefaultProvisionParameters(),fluent.getDeprovisionStatus(),fluent.getExternalProperties(),fluent.getInProgressProperties(),fluent.getLastOperation(),fluent.getObservedGeneration(),fluent.getOperationStartTime(),fluent.getOrphanMitigationInProgress(),fluent.getProvisionStatus(),fluent.getReconciledGeneration());
    return buildable;
  }
  
}