package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceInstanceSpecFluent<A extends ServiceInstanceSpecFluent<A>> extends Fluent<A>{
  public String getClusterServiceClassExternalID();
  public A withClusterServiceClassExternalID(String clusterServiceClassExternalID);
  public Boolean hasClusterServiceClassExternalID();
  public String getClusterServiceClassExternalName();
  public A withClusterServiceClassExternalName(String clusterServiceClassExternalName);
  public Boolean hasClusterServiceClassExternalName();
  public String getClusterServiceClassName();
  public A withClusterServiceClassName(String clusterServiceClassName);
  public Boolean hasClusterServiceClassName();
  
  /**
   * This method has been deprecated, please use method buildClusterServiceClassRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterObjectReference getClusterServiceClassRef();
  public ClusterObjectReference buildClusterServiceClassRef();
  public A withClusterServiceClassRef(ClusterObjectReference clusterServiceClassRef);
  public Boolean hasClusterServiceClassRef();
  public A withNewClusterServiceClassRef(String name);
  public ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> withNewClusterServiceClassRef();
  public ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> withNewClusterServiceClassRefLike(ClusterObjectReference item);
  public ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> editClusterServiceClassRef();
  public ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> editOrNewClusterServiceClassRef();
  public ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> editOrNewClusterServiceClassRefLike(ClusterObjectReference item);
  public String getClusterServicePlanExternalID();
  public A withClusterServicePlanExternalID(String clusterServicePlanExternalID);
  public Boolean hasClusterServicePlanExternalID();
  public String getClusterServicePlanExternalName();
  public A withClusterServicePlanExternalName(String clusterServicePlanExternalName);
  public Boolean hasClusterServicePlanExternalName();
  public String getClusterServicePlanName();
  public A withClusterServicePlanName(String clusterServicePlanName);
  public Boolean hasClusterServicePlanName();
  
  /**
   * This method has been deprecated, please use method buildClusterServicePlanRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterObjectReference getClusterServicePlanRef();
  public ClusterObjectReference buildClusterServicePlanRef();
  public A withClusterServicePlanRef(ClusterObjectReference clusterServicePlanRef);
  public Boolean hasClusterServicePlanRef();
  public A withNewClusterServicePlanRef(String name);
  public ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> withNewClusterServicePlanRef();
  public ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> withNewClusterServicePlanRefLike(ClusterObjectReference item);
  public ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> editClusterServicePlanRef();
  public ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> editOrNewClusterServicePlanRef();
  public ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> editOrNewClusterServicePlanRefLike(ClusterObjectReference item);
  public String getExternalID();
  public A withExternalID(String externalID);
  public Boolean hasExternalID();
  public A addToParameters(String key,Object value);
  public A addToParameters(Map<String,Object> map);
  public A removeFromParameters(String key);
  public A removeFromParameters(Map<String,Object> map);
  public Map<String,Object> getParameters();
  public <K,V>A withParameters(Map<String,Object> parameters);
  public Boolean hasParameters();
  public A addToParametersFrom(Integer index,ParametersFromSource item);
  public A setToParametersFrom(Integer index,ParametersFromSource item);
  public A addToParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... items);
  public A addAllToParametersFrom(Collection<ParametersFromSource> items);
  public A removeFromParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... items);
  public A removeAllFromParametersFrom(Collection<ParametersFromSource> items);
  public A removeMatchingFromParametersFrom(Predicate<ParametersFromSourceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildParametersFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ParametersFromSource> getParametersFrom();
  public List<ParametersFromSource> buildParametersFrom();
  public ParametersFromSource buildParametersFrom(Integer index);
  public ParametersFromSource buildFirstParametersFrom();
  public ParametersFromSource buildLastParametersFrom();
  public ParametersFromSource buildMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate);
  public Boolean hasMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate);
  public A withParametersFrom(List<ParametersFromSource> parametersFrom);
  public A withParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... parametersFrom);
  public Boolean hasParametersFrom();
  public ServiceInstanceSpecFluent.ParametersFromNested<A> addNewParametersFrom();
  public ServiceInstanceSpecFluent.ParametersFromNested<A> addNewParametersFromLike(ParametersFromSource item);
  public ServiceInstanceSpecFluent.ParametersFromNested<A> setNewParametersFromLike(Integer index,ParametersFromSource item);
  public ServiceInstanceSpecFluent.ParametersFromNested<A> editParametersFrom(Integer index);
  public ServiceInstanceSpecFluent.ParametersFromNested<A> editFirstParametersFrom();
  public ServiceInstanceSpecFluent.ParametersFromNested<A> editLastParametersFrom();
  public ServiceInstanceSpecFluent.ParametersFromNested<A> editMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate);
  public String getServiceClassExternalID();
  public A withServiceClassExternalID(String serviceClassExternalID);
  public Boolean hasServiceClassExternalID();
  public String getServiceClassExternalName();
  public A withServiceClassExternalName(String serviceClassExternalName);
  public Boolean hasServiceClassExternalName();
  public String getServiceClassName();
  public A withServiceClassName(String serviceClassName);
  public Boolean hasServiceClassName();
  
  /**
   * This method has been deprecated, please use method buildServiceClassRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getServiceClassRef();
  public LocalObjectReference buildServiceClassRef();
  public A withServiceClassRef(LocalObjectReference serviceClassRef);
  public Boolean hasServiceClassRef();
  public A withNewServiceClassRef(String name);
  public ServiceInstanceSpecFluent.ServiceClassRefNested<A> withNewServiceClassRef();
  public ServiceInstanceSpecFluent.ServiceClassRefNested<A> withNewServiceClassRefLike(LocalObjectReference item);
  public ServiceInstanceSpecFluent.ServiceClassRefNested<A> editServiceClassRef();
  public ServiceInstanceSpecFluent.ServiceClassRefNested<A> editOrNewServiceClassRef();
  public ServiceInstanceSpecFluent.ServiceClassRefNested<A> editOrNewServiceClassRefLike(LocalObjectReference item);
  public String getServicePlanExternalID();
  public A withServicePlanExternalID(String servicePlanExternalID);
  public Boolean hasServicePlanExternalID();
  public String getServicePlanExternalName();
  public A withServicePlanExternalName(String servicePlanExternalName);
  public Boolean hasServicePlanExternalName();
  public String getServicePlanName();
  public A withServicePlanName(String servicePlanName);
  public Boolean hasServicePlanName();
  
  /**
   * This method has been deprecated, please use method buildServicePlanRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getServicePlanRef();
  public LocalObjectReference buildServicePlanRef();
  public A withServicePlanRef(LocalObjectReference servicePlanRef);
  public Boolean hasServicePlanRef();
  public A withNewServicePlanRef(String name);
  public ServiceInstanceSpecFluent.ServicePlanRefNested<A> withNewServicePlanRef();
  public ServiceInstanceSpecFluent.ServicePlanRefNested<A> withNewServicePlanRefLike(LocalObjectReference item);
  public ServiceInstanceSpecFluent.ServicePlanRefNested<A> editServicePlanRef();
  public ServiceInstanceSpecFluent.ServicePlanRefNested<A> editOrNewServicePlanRef();
  public ServiceInstanceSpecFluent.ServicePlanRefNested<A> editOrNewServicePlanRefLike(LocalObjectReference item);
  public Long getUpdateRequests();
  public A withUpdateRequests(Long updateRequests);
  public Boolean hasUpdateRequests();
  
  /**
   * This method has been deprecated, please use method buildUserInfo instead.
   * @return The buildable object.
   */
  @Deprecated
  public UserInfo getUserInfo();
  public UserInfo buildUserInfo();
  public A withUserInfo(UserInfo userInfo);
  public Boolean hasUserInfo();
  public ServiceInstanceSpecFluent.UserInfoNested<A> withNewUserInfo();
  public ServiceInstanceSpecFluent.UserInfoNested<A> withNewUserInfoLike(UserInfo item);
  public ServiceInstanceSpecFluent.UserInfoNested<A> editUserInfo();
  public ServiceInstanceSpecFluent.UserInfoNested<A> editOrNewUserInfo();
  public ServiceInstanceSpecFluent.UserInfoNested<A> editOrNewUserInfoLike(UserInfo item);
  public interface ClusterServiceClassRefNested<N> extends Nested<N>,ClusterObjectReferenceFluent<ServiceInstanceSpecFluent.ClusterServiceClassRefNested<N>>{
    public N and();
    public N endClusterServiceClassRef();
    
  }
  public interface ClusterServicePlanRefNested<N> extends Nested<N>,ClusterObjectReferenceFluent<ServiceInstanceSpecFluent.ClusterServicePlanRefNested<N>>{
    public N and();
    public N endClusterServicePlanRef();
    
  }
  public interface ParametersFromNested<N> extends Nested<N>,ParametersFromSourceFluent<ServiceInstanceSpecFluent.ParametersFromNested<N>>{
    public N and();
    public N endParametersFrom();
    
  }
  public interface ServiceClassRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<ServiceInstanceSpecFluent.ServiceClassRefNested<N>>{
    public N and();
    public N endServiceClassRef();
    
  }
  public interface ServicePlanRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<ServiceInstanceSpecFluent.ServicePlanRefNested<N>>{
    public N and();
    public N endServicePlanRef();
    
  }
  public interface UserInfoNested<N> extends Nested<N>,UserInfoFluent<ServiceInstanceSpecFluent.UserInfoNested<N>>{
    public N and();
    public N endUserInfo();
    
  }
  
}