package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceInstancePropertiesStateFluentImpl<A extends ServiceInstancePropertiesStateFluent<A>> extends BaseFluent<A> implements ServiceInstancePropertiesStateFluent<A>{
  public ServiceInstancePropertiesStateFluentImpl() {
  }
  public ServiceInstancePropertiesStateFluentImpl(ServiceInstancePropertiesState instance) {
    this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID()); 
    this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName()); 
    this.withParameterChecksum(instance.getParameterChecksum()); 
    this.withParameters(instance.getParameters()); 
    this.withServicePlanExternalID(instance.getServicePlanExternalID()); 
    this.withServicePlanExternalName(instance.getServicePlanExternalName()); 
    this.withUserInfo(instance.getUserInfo()); 
  }
  private String clusterServicePlanExternalID;
  private String clusterServicePlanExternalName;
  private String parameterChecksum;
  private Map<String,Object> parameters;
  private String servicePlanExternalID;
  private String servicePlanExternalName;
  private UserInfoBuilder userInfo;
  public String getClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID;
  }
  public A withClusterServicePlanExternalID(String clusterServicePlanExternalID) {
    this.clusterServicePlanExternalID=clusterServicePlanExternalID; return (A) this;
  }
  public Boolean hasClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID != null;
  }
  public String getClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName;
  }
  public A withClusterServicePlanExternalName(String clusterServicePlanExternalName) {
    this.clusterServicePlanExternalName=clusterServicePlanExternalName; return (A) this;
  }
  public Boolean hasClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName != null;
  }
  public String getParameterChecksum() {
    return this.parameterChecksum;
  }
  public A withParameterChecksum(String parameterChecksum) {
    this.parameterChecksum=parameterChecksum; return (A) this;
  }
  public Boolean hasParameterChecksum() {
    return this.parameterChecksum != null;
  }
  public A addToParameters(String key,Object value) {
    if(this.parameters == null && key != null && value != null) { this.parameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.parameters.put(key, value);} return (A)this;
  }
  public A addToParameters(Map<String,Object> map) {
    if(this.parameters == null && map != null) { this.parameters = new LinkedHashMap(); }
    if(map != null) { this.parameters.putAll(map);} return (A)this;
  }
  public A removeFromParameters(String key) {
    if(this.parameters == null) { return (A) this; }
    if(key != null && this.parameters != null) {this.parameters.remove(key);} return (A)this;
  }
  public A removeFromParameters(Map<String,Object> map) {
    if(this.parameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.parameters != null){this.parameters.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getParameters() {
    return this.parameters;
  }
  public <K,V>A withParameters(Map<String,Object> parameters) {
    if (parameters == null) { this.parameters =  null;} else {this.parameters = new LinkedHashMap(parameters);} return (A) this;
  }
  public Boolean hasParameters() {
    return this.parameters != null;
  }
  public String getServicePlanExternalID() {
    return this.servicePlanExternalID;
  }
  public A withServicePlanExternalID(String servicePlanExternalID) {
    this.servicePlanExternalID=servicePlanExternalID; return (A) this;
  }
  public Boolean hasServicePlanExternalID() {
    return this.servicePlanExternalID != null;
  }
  public String getServicePlanExternalName() {
    return this.servicePlanExternalName;
  }
  public A withServicePlanExternalName(String servicePlanExternalName) {
    this.servicePlanExternalName=servicePlanExternalName; return (A) this;
  }
  public Boolean hasServicePlanExternalName() {
    return this.servicePlanExternalName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUserInfo instead.
   * @return The buildable object.
   */
  @Deprecated
  public UserInfo getUserInfo() {
    return this.userInfo!=null ?this.userInfo.build():null;
  }
  public UserInfo buildUserInfo() {
    return this.userInfo!=null ?this.userInfo.build():null;
  }
  public A withUserInfo(UserInfo userInfo) {
    _visitables.get("userInfo").remove(this.userInfo);
    if (userInfo!=null){ this.userInfo= new UserInfoBuilder(userInfo); _visitables.get("userInfo").add(this.userInfo);} else { this.userInfo = null; _visitables.get("userInfo").remove(this.userInfo); } return (A) this;
  }
  public Boolean hasUserInfo() {
    return this.userInfo != null;
  }
  public ServiceInstancePropertiesStateFluent.UserInfoNested<A> withNewUserInfo() {
    return new ServiceInstancePropertiesStateFluentImpl.UserInfoNestedImpl();
  }
  public ServiceInstancePropertiesStateFluent.UserInfoNested<A> withNewUserInfoLike(UserInfo item) {
    return new ServiceInstancePropertiesStateFluentImpl.UserInfoNestedImpl(item);
  }
  public ServiceInstancePropertiesStateFluent.UserInfoNested<A> editUserInfo() {
    return withNewUserInfoLike(getUserInfo());
  }
  public ServiceInstancePropertiesStateFluent.UserInfoNested<A> editOrNewUserInfo() {
    return withNewUserInfoLike(getUserInfo() != null ? getUserInfo(): new UserInfoBuilder().build());
  }
  public ServiceInstancePropertiesStateFluent.UserInfoNested<A> editOrNewUserInfoLike(UserInfo item) {
    return withNewUserInfoLike(getUserInfo() != null ? getUserInfo(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceInstancePropertiesStateFluentImpl that = (ServiceInstancePropertiesStateFluentImpl) o;
    if (clusterServicePlanExternalID != null ? !clusterServicePlanExternalID.equals(that.clusterServicePlanExternalID) :that.clusterServicePlanExternalID != null) return false;
    if (clusterServicePlanExternalName != null ? !clusterServicePlanExternalName.equals(that.clusterServicePlanExternalName) :that.clusterServicePlanExternalName != null) return false;
    if (parameterChecksum != null ? !parameterChecksum.equals(that.parameterChecksum) :that.parameterChecksum != null) return false;
    if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
    if (servicePlanExternalID != null ? !servicePlanExternalID.equals(that.servicePlanExternalID) :that.servicePlanExternalID != null) return false;
    if (servicePlanExternalName != null ? !servicePlanExternalName.equals(that.servicePlanExternalName) :that.servicePlanExternalName != null) return false;
    if (userInfo != null ? !userInfo.equals(that.userInfo) :that.userInfo != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterServicePlanExternalID,  clusterServicePlanExternalName,  parameterChecksum,  parameters,  servicePlanExternalID,  servicePlanExternalName,  userInfo,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterServicePlanExternalID != null) { sb.append("clusterServicePlanExternalID:"); sb.append(clusterServicePlanExternalID + ","); }
    if (clusterServicePlanExternalName != null) { sb.append("clusterServicePlanExternalName:"); sb.append(clusterServicePlanExternalName + ","); }
    if (parameterChecksum != null) { sb.append("parameterChecksum:"); sb.append(parameterChecksum + ","); }
    if (parameters != null && !parameters.isEmpty()) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (servicePlanExternalID != null) { sb.append("servicePlanExternalID:"); sb.append(servicePlanExternalID + ","); }
    if (servicePlanExternalName != null) { sb.append("servicePlanExternalName:"); sb.append(servicePlanExternalName + ","); }
    if (userInfo != null) { sb.append("userInfo:"); sb.append(userInfo); }
    sb.append("}");
    return sb.toString();
  }
  class UserInfoNestedImpl<N> extends UserInfoFluentImpl<ServiceInstancePropertiesStateFluent.UserInfoNested<N>> implements ServiceInstancePropertiesStateFluent.UserInfoNested<N>,Nested<N>{
    UserInfoNestedImpl(UserInfo item) {
      this.builder = new UserInfoBuilder(this, item);
    }
    UserInfoNestedImpl() {
      this.builder = new UserInfoBuilder(this);
    }
    UserInfoBuilder builder;
    public N and() {
      return (N) ServiceInstancePropertiesStateFluentImpl.this.withUserInfo(builder.build());
    }
    public N endUserInfo() {
      return and();
    }
    
  }
  
}