package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceInstanceBuilder extends ServiceInstanceFluentImpl<ServiceInstanceBuilder> implements VisitableBuilder<ServiceInstance,ServiceInstanceBuilder>{
  public ServiceInstanceBuilder() {
    this(false);
  }
  public ServiceInstanceBuilder(Boolean validationEnabled) {
    this(new ServiceInstance(), validationEnabled);
  }
  public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceInstance(), validationEnabled);
  }
  public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent,ServiceInstance instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent,ServiceInstance instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceBuilder(ServiceInstance instance) {
    this(instance,false);
  }
  public ServiceInstanceBuilder(ServiceInstance instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceInstanceFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceInstance build() {
    ServiceInstance buildable = new ServiceInstance(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}