package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBindingBuilder extends ServiceBindingFluentImpl<ServiceBindingBuilder> implements VisitableBuilder<ServiceBinding,ServiceBindingBuilder>{
  public ServiceBindingBuilder() {
    this(false);
  }
  public ServiceBindingBuilder(Boolean validationEnabled) {
    this(new ServiceBinding(), validationEnabled);
  }
  public ServiceBindingBuilder(ServiceBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBindingBuilder(ServiceBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBinding(), validationEnabled);
  }
  public ServiceBindingBuilder(ServiceBindingFluent<?> fluent,ServiceBinding instance) {
    this(fluent, instance, false);
  }
  public ServiceBindingBuilder(ServiceBindingFluent<?> fluent,ServiceBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBindingBuilder(ServiceBinding instance) {
    this(instance,false);
  }
  public ServiceBindingBuilder(ServiceBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceBindingFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBinding build() {
    ServiceBinding buildable = new ServiceBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}