package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServicePlanStatusBuilder extends ClusterServicePlanStatusFluentImpl<ClusterServicePlanStatusBuilder> implements VisitableBuilder<ClusterServicePlanStatus,ClusterServicePlanStatusBuilder>{
  public ClusterServicePlanStatusBuilder() {
    this(false);
  }
  public ClusterServicePlanStatusBuilder(Boolean validationEnabled) {
    this(new ClusterServicePlanStatus(), validationEnabled);
  }
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServicePlanStatus(), validationEnabled);
  }
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatusFluent<?> fluent,ClusterServicePlanStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatusFluent<?> fluent,ClusterServicePlanStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatus instance) {
    this(instance,false);
  }
  public ClusterServicePlanStatusBuilder(ClusterServicePlanStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterServicePlanStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServicePlanStatus build() {
    ClusterServicePlanStatus buildable = new ClusterServicePlanStatus(fluent.getRemovedFromBrokerCatalog());
    return buildable;
  }
  
}