package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BasicAuthConfigBuilder extends BasicAuthConfigFluentImpl<BasicAuthConfigBuilder> implements VisitableBuilder<BasicAuthConfig,BasicAuthConfigBuilder>{
  public BasicAuthConfigBuilder() {
    this(false);
  }
  public BasicAuthConfigBuilder(Boolean validationEnabled) {
    this(new BasicAuthConfig(), validationEnabled);
  }
  public BasicAuthConfigBuilder(BasicAuthConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public BasicAuthConfigBuilder(BasicAuthConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BasicAuthConfig(), validationEnabled);
  }
  public BasicAuthConfigBuilder(BasicAuthConfigFluent<?> fluent,BasicAuthConfig instance) {
    this(fluent, instance, false);
  }
  public BasicAuthConfigBuilder(BasicAuthConfigFluent<?> fluent,BasicAuthConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public BasicAuthConfigBuilder(BasicAuthConfig instance) {
    this(instance,false);
  }
  public BasicAuthConfigBuilder(BasicAuthConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  BasicAuthConfigFluent<?> fluent;
  Boolean validationEnabled;
  public BasicAuthConfig build() {
    BasicAuthConfig buildable = new BasicAuthConfig(fluent.getSecretRef());
    return buildable;
  }
  
}