package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UserOAuthAccessTokenBuilder extends UserOAuthAccessTokenFluentImpl<UserOAuthAccessTokenBuilder> implements VisitableBuilder<UserOAuthAccessToken,UserOAuthAccessTokenBuilder>{
  public UserOAuthAccessTokenBuilder() {
    this(false);
  }
  public UserOAuthAccessTokenBuilder(Boolean validationEnabled) {
    this(new UserOAuthAccessToken(), validationEnabled);
  }
  public UserOAuthAccessTokenBuilder(UserOAuthAccessTokenFluent<?> fluent) {
    this(fluent, false);
  }
  public UserOAuthAccessTokenBuilder(UserOAuthAccessTokenFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UserOAuthAccessToken(), validationEnabled);
  }
  public UserOAuthAccessTokenBuilder(UserOAuthAccessTokenFluent<?> fluent,UserOAuthAccessToken instance) {
    this(fluent, instance, false);
  }
  public UserOAuthAccessTokenBuilder(UserOAuthAccessTokenFluent<?> fluent,UserOAuthAccessToken instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withAuthorizeToken(instance.getAuthorizeToken());
      fluent.withClientName(instance.getClientName());
      fluent.withExpiresIn(instance.getExpiresIn());
      fluent.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRedirectURI(instance.getRedirectURI());
      fluent.withRefreshToken(instance.getRefreshToken());
      fluent.withScopes(instance.getScopes());
      fluent.withUserName(instance.getUserName());
      fluent.withUserUID(instance.getUserUID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public UserOAuthAccessTokenBuilder(UserOAuthAccessToken instance) {
    this(instance,false);
  }
  public UserOAuthAccessTokenBuilder(UserOAuthAccessToken instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withAuthorizeToken(instance.getAuthorizeToken());
      this.withClientName(instance.getClientName());
      this.withExpiresIn(instance.getExpiresIn());
      this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRedirectURI(instance.getRedirectURI());
      this.withRefreshToken(instance.getRefreshToken());
      this.withScopes(instance.getScopes());
      this.withUserName(instance.getUserName());
      this.withUserUID(instance.getUserUID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  UserOAuthAccessTokenFluent<?> fluent;
  Boolean validationEnabled;
  public UserOAuthAccessToken build() {
    UserOAuthAccessToken buildable = new UserOAuthAccessToken(fluent.getApiVersion(),fluent.getAuthorizeToken(),fluent.getClientName(),fluent.getExpiresIn(),fluent.getInactivityTimeoutSeconds(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURI(),fluent.getRefreshToken(),fluent.getScopes(),fluent.getUserName(),fluent.getUserUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}