package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleBindingRestrictionBuilder extends RoleBindingRestrictionFluentImpl<RoleBindingRestrictionBuilder> implements VisitableBuilder<RoleBindingRestriction,RoleBindingRestrictionBuilder>{
  public RoleBindingRestrictionBuilder() {
    this(false);
  }
  public RoleBindingRestrictionBuilder(Boolean validationEnabled) {
    this(new RoleBindingRestriction(), validationEnabled);
  }
  public RoleBindingRestrictionBuilder(RoleBindingRestrictionFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBindingRestrictionBuilder(RoleBindingRestrictionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RoleBindingRestriction(), validationEnabled);
  }
  public RoleBindingRestrictionBuilder(RoleBindingRestrictionFluent<?> fluent,RoleBindingRestriction instance) {
    this(fluent, instance, false);
  }
  public RoleBindingRestrictionBuilder(RoleBindingRestrictionFluent<?> fluent,RoleBindingRestriction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RoleBindingRestrictionBuilder(RoleBindingRestriction instance) {
    this(instance,false);
  }
  public RoleBindingRestrictionBuilder(RoleBindingRestriction instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RoleBindingRestrictionFluent<?> fluent;
  Boolean validationEnabled;
  public RoleBindingRestriction build() {
    RoleBindingRestriction buildable = new RoleBindingRestriction(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}