package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RepositoryImportSpecFluentImpl<A extends RepositoryImportSpecFluent<A>> extends BaseFluent<A> implements RepositoryImportSpecFluent<A>{
  public RepositoryImportSpecFluentImpl() {
  }
  public RepositoryImportSpecFluentImpl(RepositoryImportSpec instance) {
    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withImportPolicy(instance.getImportPolicy());
      this.withIncludeManifest(instance.getIncludeManifest());
      this.withReferencePolicy(instance.getReferencePolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ObjectReferenceBuilder from;
  private TagImportPolicyBuilder importPolicy;
  private Boolean includeManifest;
  private TagReferencePolicyBuilder referencePolicy;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} else { this.from = null; _visitables.get("from").remove(this.from); } return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public RepositoryImportSpecFluentImpl.FromNested<A> withNewFrom() {
    return new RepositoryImportSpecFluentImpl.FromNestedImpl();
  }
  public RepositoryImportSpecFluentImpl.FromNested<A> withNewFromLike(ObjectReference item) {
    return new RepositoryImportSpecFluentImpl.FromNestedImpl(item);
  }
  public RepositoryImportSpecFluentImpl.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public RepositoryImportSpecFluentImpl.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
  }
  public RepositoryImportSpecFluentImpl.FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildImportPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagImportPolicy getImportPolicy() {
    return this.importPolicy!=null ?this.importPolicy.build():null;
  }
  public TagImportPolicy buildImportPolicy() {
    return this.importPolicy!=null ?this.importPolicy.build():null;
  }
  public A withImportPolicy(TagImportPolicy importPolicy) {
    _visitables.get("importPolicy").remove(this.importPolicy);
    if (importPolicy!=null){ this.importPolicy= new TagImportPolicyBuilder(importPolicy); _visitables.get("importPolicy").add(this.importPolicy);} else { this.importPolicy = null; _visitables.get("importPolicy").remove(this.importPolicy); } return (A) this;
  }
  public Boolean hasImportPolicy() {
    return this.importPolicy != null;
  }
  public A withNewImportPolicy(Boolean insecure,Boolean scheduled) {
    return (A)withImportPolicy(new TagImportPolicy(insecure, scheduled));
  }
  public RepositoryImportSpecFluentImpl.ImportPolicyNested<A> withNewImportPolicy() {
    return new RepositoryImportSpecFluentImpl.ImportPolicyNestedImpl();
  }
  public RepositoryImportSpecFluentImpl.ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item) {
    return new RepositoryImportSpecFluentImpl.ImportPolicyNestedImpl(item);
  }
  public RepositoryImportSpecFluentImpl.ImportPolicyNested<A> editImportPolicy() {
    return withNewImportPolicyLike(getImportPolicy());
  }
  public RepositoryImportSpecFluentImpl.ImportPolicyNested<A> editOrNewImportPolicy() {
    return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): new TagImportPolicyBuilder().build());
  }
  public RepositoryImportSpecFluentImpl.ImportPolicyNested<A> editOrNewImportPolicyLike(TagImportPolicy item) {
    return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): item);
  }
  public Boolean getIncludeManifest() {
    return this.includeManifest;
  }
  public A withIncludeManifest(Boolean includeManifest) {
    this.includeManifest=includeManifest; return (A) this;
  }
  public Boolean hasIncludeManifest() {
    return this.includeManifest != null;
  }
  
  /**
   * This method has been deprecated, please use method buildReferencePolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagReferencePolicy getReferencePolicy() {
    return this.referencePolicy!=null ?this.referencePolicy.build():null;
  }
  public TagReferencePolicy buildReferencePolicy() {
    return this.referencePolicy!=null ?this.referencePolicy.build():null;
  }
  public A withReferencePolicy(TagReferencePolicy referencePolicy) {
    _visitables.get("referencePolicy").remove(this.referencePolicy);
    if (referencePolicy!=null){ this.referencePolicy= new TagReferencePolicyBuilder(referencePolicy); _visitables.get("referencePolicy").add(this.referencePolicy);} else { this.referencePolicy = null; _visitables.get("referencePolicy").remove(this.referencePolicy); } return (A) this;
  }
  public Boolean hasReferencePolicy() {
    return this.referencePolicy != null;
  }
  public A withNewReferencePolicy(String type) {
    return (A)withReferencePolicy(new TagReferencePolicy(type));
  }
  public RepositoryImportSpecFluentImpl.ReferencePolicyNested<A> withNewReferencePolicy() {
    return new RepositoryImportSpecFluentImpl.ReferencePolicyNestedImpl();
  }
  public RepositoryImportSpecFluentImpl.ReferencePolicyNested<A> withNewReferencePolicyLike(TagReferencePolicy item) {
    return new RepositoryImportSpecFluentImpl.ReferencePolicyNestedImpl(item);
  }
  public RepositoryImportSpecFluentImpl.ReferencePolicyNested<A> editReferencePolicy() {
    return withNewReferencePolicyLike(getReferencePolicy());
  }
  public RepositoryImportSpecFluentImpl.ReferencePolicyNested<A> editOrNewReferencePolicy() {
    return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): new TagReferencePolicyBuilder().build());
  }
  public RepositoryImportSpecFluentImpl.ReferencePolicyNested<A> editOrNewReferencePolicyLike(TagReferencePolicy item) {
    return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RepositoryImportSpecFluentImpl that = (RepositoryImportSpecFluentImpl) o;
    if (!java.util.Objects.equals(from, that.from)) return false;

    if (!java.util.Objects.equals(importPolicy, that.importPolicy)) return false;

    if (!java.util.Objects.equals(includeManifest, that.includeManifest)) return false;

    if (!java.util.Objects.equals(referencePolicy, that.referencePolicy)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(from,  importPolicy,  includeManifest,  referencePolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (importPolicy != null) { sb.append("importPolicy:"); sb.append(importPolicy + ","); }
    if (includeManifest != null) { sb.append("includeManifest:"); sb.append(includeManifest + ","); }
    if (referencePolicy != null) { sb.append("referencePolicy:"); sb.append(referencePolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withIncludeManifest() {
    return withIncludeManifest(true);
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<RepositoryImportSpecFluentImpl.FromNested<N>> implements RepositoryImportSpecFluentImpl.FromNested<N>,Nested<N>{
    FromNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) RepositoryImportSpecFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  class ImportPolicyNestedImpl<N> extends TagImportPolicyFluentImpl<RepositoryImportSpecFluentImpl.ImportPolicyNested<N>> implements RepositoryImportSpecFluentImpl.ImportPolicyNested<N>,Nested<N>{
    ImportPolicyNestedImpl(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    ImportPolicyNestedImpl() {
      this.builder = new TagImportPolicyBuilder(this);
    }
    TagImportPolicyBuilder builder;
    public N and() {
      return (N) RepositoryImportSpecFluentImpl.this.withImportPolicy(builder.build());
    }
    public N endImportPolicy() {
      return and();
    }
    
  }
  class ReferencePolicyNestedImpl<N> extends TagReferencePolicyFluentImpl<RepositoryImportSpecFluentImpl.ReferencePolicyNested<N>> implements RepositoryImportSpecFluentImpl.ReferencePolicyNested<N>,Nested<N>{
    ReferencePolicyNestedImpl(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    ReferencePolicyNestedImpl() {
      this.builder = new TagReferencePolicyBuilder(this);
    }
    TagReferencePolicyBuilder builder;
    public N and() {
      return (N) RepositoryImportSpecFluentImpl.this.withReferencePolicy(builder.build());
    }
    public N endReferencePolicy() {
      return and();
    }
    
  }
  
}