package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSecurityPolicyReviewFluentImpl<A extends PodSecurityPolicyReviewFluent<A>> extends BaseFluent<A> implements PodSecurityPolicyReviewFluent<A>{
  public PodSecurityPolicyReviewFluentImpl() {
  }
  public PodSecurityPolicyReviewFluentImpl(PodSecurityPolicyReview instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private PodSecurityPolicyReviewSpecBuilder spec;
  private PodSecurityPolicyReviewStatusBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSecurityPolicyReviewSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public PodSecurityPolicyReviewSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(PodSecurityPolicyReviewSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new PodSecurityPolicyReviewSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public PodSecurityPolicyReviewFluentImpl.SpecNested<A> withNewSpec() {
    return new PodSecurityPolicyReviewFluentImpl.SpecNestedImpl();
  }
  public PodSecurityPolicyReviewFluentImpl.SpecNested<A> withNewSpecLike(PodSecurityPolicyReviewSpec item) {
    return new PodSecurityPolicyReviewFluentImpl.SpecNestedImpl(item);
  }
  public PodSecurityPolicyReviewFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public PodSecurityPolicyReviewFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new PodSecurityPolicyReviewSpecBuilder().build());
  }
  public PodSecurityPolicyReviewFluentImpl.SpecNested<A> editOrNewSpecLike(PodSecurityPolicyReviewSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSecurityPolicyReviewStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public PodSecurityPolicyReviewStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(PodSecurityPolicyReviewStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new PodSecurityPolicyReviewStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public PodSecurityPolicyReviewFluentImpl.StatusNested<A> withNewStatus() {
    return new PodSecurityPolicyReviewFluentImpl.StatusNestedImpl();
  }
  public PodSecurityPolicyReviewFluentImpl.StatusNested<A> withNewStatusLike(PodSecurityPolicyReviewStatus item) {
    return new PodSecurityPolicyReviewFluentImpl.StatusNestedImpl(item);
  }
  public PodSecurityPolicyReviewFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public PodSecurityPolicyReviewFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new PodSecurityPolicyReviewStatusBuilder().build());
  }
  public PodSecurityPolicyReviewFluentImpl.StatusNested<A> editOrNewStatusLike(PodSecurityPolicyReviewStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodSecurityPolicyReviewFluentImpl that = (PodSecurityPolicyReviewFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SpecNestedImpl<N> extends PodSecurityPolicyReviewSpecFluentImpl<PodSecurityPolicyReviewFluentImpl.SpecNested<N>> implements PodSecurityPolicyReviewFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(PodSecurityPolicyReviewSpec item) {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this);
    }
    PodSecurityPolicyReviewSpecBuilder builder;
    public N and() {
      return (N) PodSecurityPolicyReviewFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends PodSecurityPolicyReviewStatusFluentImpl<PodSecurityPolicyReviewFluentImpl.StatusNested<N>> implements PodSecurityPolicyReviewFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(PodSecurityPolicyReviewStatus item) {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this);
    }
    PodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) PodSecurityPolicyReviewFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}