package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthClientListBuilder extends OAuthClientListFluentImpl<OAuthClientListBuilder> implements VisitableBuilder<OAuthClientList,OAuthClientListBuilder>{
  public OAuthClientListBuilder() {
    this(false);
  }
  public OAuthClientListBuilder(Boolean validationEnabled) {
    this(new OAuthClientList(), validationEnabled);
  }
  public OAuthClientListBuilder(OAuthClientListFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthClientListBuilder(OAuthClientListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthClientList(), validationEnabled);
  }
  public OAuthClientListBuilder(OAuthClientListFluent<?> fluent,OAuthClientList instance) {
    this(fluent, instance, false);
  }
  public OAuthClientListBuilder(OAuthClientListFluent<?> fluent,OAuthClientList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OAuthClientListBuilder(OAuthClientList instance) {
    this(instance,false);
  }
  public OAuthClientListBuilder(OAuthClientList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OAuthClientListFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthClientList build() {
    OAuthClientList buildable = new OAuthClientList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}