package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedTagEventListBuilder extends NamedTagEventListFluentImpl<NamedTagEventListBuilder> implements VisitableBuilder<NamedTagEventList,NamedTagEventListBuilder>{
  public NamedTagEventListBuilder() {
    this(false);
  }
  public NamedTagEventListBuilder(Boolean validationEnabled) {
    this(new NamedTagEventList(), validationEnabled);
  }
  public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamedTagEventList(), validationEnabled);
  }
  public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent,NamedTagEventList instance) {
    this(fluent, instance, false);
  }
  public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent,NamedTagEventList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withItems(instance.getItems());
      fluent.withTag(instance.getTag());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamedTagEventListBuilder(NamedTagEventList instance) {
    this(instance,false);
  }
  public NamedTagEventListBuilder(NamedTagEventList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withItems(instance.getItems());
      this.withTag(instance.getTag());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamedTagEventListFluent<?> fluent;
  Boolean validationEnabled;
  public NamedTagEventList build() {
    NamedTagEventList buildable = new NamedTagEventList(fluent.getConditions(),fluent.getItems(),fluent.getTag());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}