package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamBuilder extends ImageStreamFluentImpl<ImageStreamBuilder> implements VisitableBuilder<ImageStream,ImageStreamBuilder>{
  public ImageStreamBuilder() {
    this(false);
  }
  public ImageStreamBuilder(Boolean validationEnabled) {
    this(new ImageStream(), validationEnabled);
  }
  public ImageStreamBuilder(ImageStreamFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamBuilder(ImageStreamFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStream(), validationEnabled);
  }
  public ImageStreamBuilder(ImageStreamFluent<?> fluent,ImageStream instance) {
    this(fluent, instance, false);
  }
  public ImageStreamBuilder(ImageStreamFluent<?> fluent,ImageStream instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamBuilder(ImageStream instance) {
    this(instance,false);
  }
  public ImageStreamBuilder(ImageStream instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStream build() {
    ImageStream buildable = new ImageStream(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}