package io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlacementRuleSpecFluent<A extends PlacementRuleSpecFluent<A>> extends BaseFluent<A>{
  public PlacementRuleSpecFluent() {
  }
  
  public PlacementRuleSpecFluent(PlacementRuleSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ClusterConditionFilterBuilder> clusterConditions = new ArrayList<ClusterConditionFilterBuilder>();
  private Integer clusterReplicas;
  private LabelSelectorBuilder clusterSelector;
  private ArrayList<GenericClusterReferenceBuilder> clusters = new ArrayList<GenericClusterReferenceBuilder>();
  private ArrayList<ObjectReferenceBuilder> policies = new ArrayList<ObjectReferenceBuilder>();
  private ResourceHintBuilder resourceHint;
  private String schedulerName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PlacementRuleSpec instance) {
    instance = (instance != null ? instance : new PlacementRuleSpec());
    if (instance != null) {
          this.withClusterConditions(instance.getClusterConditions());
          this.withClusterReplicas(instance.getClusterReplicas());
          this.withClusterSelector(instance.getClusterSelector());
          this.withClusters(instance.getClusters());
          this.withPolicies(instance.getPolicies());
          this.withResourceHint(instance.getResourceHint());
          this.withSchedulerName(instance.getSchedulerName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToClusterConditions(int index,ClusterConditionFilter item) {
    if (this.clusterConditions == null) {this.clusterConditions = new ArrayList<ClusterConditionFilterBuilder>();}
    ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);
    if (index < 0 || index >= clusterConditions.size()) { _visitables.get("clusterConditions").add(builder); clusterConditions.add(builder); } else { _visitables.get("clusterConditions").add(index, builder); clusterConditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToClusterConditions(int index,ClusterConditionFilter item) {
    if (this.clusterConditions == null) {this.clusterConditions = new ArrayList<ClusterConditionFilterBuilder>();}
    ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);
    if (index < 0 || index >= clusterConditions.size()) { _visitables.get("clusterConditions").add(builder); clusterConditions.add(builder); } else { _visitables.get("clusterConditions").set(index, builder); clusterConditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToClusterConditions(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ClusterConditionFilter... items) {
    if (this.clusterConditions == null) {this.clusterConditions = new ArrayList<ClusterConditionFilterBuilder>();}
    for (ClusterConditionFilter item : items) {ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);_visitables.get("clusterConditions").add(builder);this.clusterConditions.add(builder);} return (A)this;
  }
  
  public A addAllToClusterConditions(Collection<ClusterConditionFilter> items) {
    if (this.clusterConditions == null) {this.clusterConditions = new ArrayList<ClusterConditionFilterBuilder>();}
    for (ClusterConditionFilter item : items) {ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);_visitables.get("clusterConditions").add(builder);this.clusterConditions.add(builder);} return (A)this;
  }
  
  public A removeFromClusterConditions(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ClusterConditionFilter... items) {
    if (this.clusterConditions == null) return (A)this;
    for (ClusterConditionFilter item : items) {ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);_visitables.get("clusterConditions").remove(builder); this.clusterConditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusterConditions(Collection<ClusterConditionFilter> items) {
    if (this.clusterConditions == null) return (A)this;
    for (ClusterConditionFilter item : items) {ClusterConditionFilterBuilder builder = new ClusterConditionFilterBuilder(item);_visitables.get("clusterConditions").remove(builder); this.clusterConditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusterConditions(Predicate<ClusterConditionFilterBuilder> predicate) {
    if (clusterConditions == null) return (A) this;
    final Iterator<ClusterConditionFilterBuilder> each = clusterConditions.iterator();
    final List visitables = _visitables.get("clusterConditions");
    while (each.hasNext()) {
      ClusterConditionFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterConditionFilter> buildClusterConditions() {
    return this.clusterConditions != null ? build(clusterConditions) : null;
  }
  
  public ClusterConditionFilter buildClusterCondition(int index) {
    return this.clusterConditions.get(index).build();
  }
  
  public ClusterConditionFilter buildFirstClusterCondition() {
    return this.clusterConditions.get(0).build();
  }
  
  public ClusterConditionFilter buildLastClusterCondition() {
    return this.clusterConditions.get(clusterConditions.size() - 1).build();
  }
  
  public ClusterConditionFilter buildMatchingClusterCondition(Predicate<ClusterConditionFilterBuilder> predicate) {
      for (ClusterConditionFilterBuilder item : clusterConditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingClusterCondition(Predicate<ClusterConditionFilterBuilder> predicate) {
      for (ClusterConditionFilterBuilder item : clusterConditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusterConditions(List<ClusterConditionFilter> clusterConditions) {
    if (this.clusterConditions != null) {
      this._visitables.get("clusterConditions").clear();
    }
    if (clusterConditions != null) {
        this.clusterConditions = new ArrayList();
        for (ClusterConditionFilter item : clusterConditions) {
          this.addToClusterConditions(item);
        }
    } else {
      this.clusterConditions = null;
    }
    return (A) this;
  }
  
  public A withClusterConditions(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.ClusterConditionFilter... clusterConditions) {
    if (this.clusterConditions != null) {
        this.clusterConditions.clear();
        _visitables.remove("clusterConditions");
    }
    if (clusterConditions != null) {
      for (ClusterConditionFilter item : clusterConditions) {
        this.addToClusterConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusterConditions() {
    return this.clusterConditions != null && !this.clusterConditions.isEmpty();
  }
  
  public A addNewClusterCondition(String status,String type) {
    return (A)addToClusterConditions(new ClusterConditionFilter(status, type));
  }
  
  public ClusterConditionsNested<A> addNewClusterCondition() {
    return new ClusterConditionsNested(-1, null);
  }
  
  public ClusterConditionsNested<A> addNewClusterConditionLike(ClusterConditionFilter item) {
    return new ClusterConditionsNested(-1, item);
  }
  
  public ClusterConditionsNested<A> setNewClusterConditionLike(int index,ClusterConditionFilter item) {
    return new ClusterConditionsNested(index, item);
  }
  
  public ClusterConditionsNested<A> editClusterCondition(int index) {
    if (clusterConditions.size() <= index) throw new RuntimeException("Can't edit clusterConditions. Index exceeds size.");
    return setNewClusterConditionLike(index, buildClusterCondition(index));
  }
  
  public ClusterConditionsNested<A> editFirstClusterCondition() {
    if (clusterConditions.size() == 0) throw new RuntimeException("Can't edit first clusterConditions. The list is empty.");
    return setNewClusterConditionLike(0, buildClusterCondition(0));
  }
  
  public ClusterConditionsNested<A> editLastClusterCondition() {
    int index = clusterConditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterConditions. The list is empty.");
    return setNewClusterConditionLike(index, buildClusterCondition(index));
  }
  
  public ClusterConditionsNested<A> editMatchingClusterCondition(Predicate<ClusterConditionFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterConditions.size();i++) { 
    if (predicate.test(clusterConditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterConditions. No match found.");
    return setNewClusterConditionLike(index, buildClusterCondition(index));
  }
  
  public Integer getClusterReplicas() {
    return this.clusterReplicas;
  }
  
  public A withClusterReplicas(Integer clusterReplicas) {
    this.clusterReplicas = clusterReplicas;
    return (A) this;
  }
  
  public boolean hasClusterReplicas() {
    return this.clusterReplicas != null;
  }
  
  public LabelSelector buildClusterSelector() {
    return this.clusterSelector != null ? this.clusterSelector.build() : null;
  }
  
  public A withClusterSelector(LabelSelector clusterSelector) {
    this._visitables.remove("clusterSelector");
    if (clusterSelector != null) {
        this.clusterSelector = new LabelSelectorBuilder(clusterSelector);
        this._visitables.get("clusterSelector").add(this.clusterSelector);
    } else {
        this.clusterSelector = null;
        this._visitables.get("clusterSelector").remove(this.clusterSelector);
    }
    return (A) this;
  }
  
  public boolean hasClusterSelector() {
    return this.clusterSelector != null;
  }
  
  public ClusterSelectorNested<A> withNewClusterSelector() {
    return new ClusterSelectorNested(null);
  }
  
  public ClusterSelectorNested<A> withNewClusterSelectorLike(LabelSelector item) {
    return new ClusterSelectorNested(item);
  }
  
  public ClusterSelectorNested<A> editClusterSelector() {
    return withNewClusterSelectorLike(java.util.Optional.ofNullable(buildClusterSelector()).orElse(null));
  }
  
  public ClusterSelectorNested<A> editOrNewClusterSelector() {
    return withNewClusterSelectorLike(java.util.Optional.ofNullable(buildClusterSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public ClusterSelectorNested<A> editOrNewClusterSelectorLike(LabelSelector item) {
    return withNewClusterSelectorLike(java.util.Optional.ofNullable(buildClusterSelector()).orElse(item));
  }
  
  public A addToClusters(int index,GenericClusterReference item) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
    if (index < 0 || index >= clusters.size()) { _visitables.get("clusters").add(builder); clusters.add(builder); } else { _visitables.get("clusters").add(index, builder); clusters.add(index, builder);}
    return (A)this;
  }
  
  public A setToClusters(int index,GenericClusterReference item) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
    if (index < 0 || index >= clusters.size()) { _visitables.get("clusters").add(builder); clusters.add(builder); } else { _visitables.get("clusters").set(index, builder); clusters.set(index, builder);}
    return (A)this;
  }
  
  public A addToClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.GenericClusterReference... items) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  
  public A addAllToClusters(Collection<GenericClusterReference> items) {
    if (this.clusters == null) {this.clusters = new ArrayList<GenericClusterReferenceBuilder>();}
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  
  public A removeFromClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.GenericClusterReference... items) {
    if (this.clusters == null) return (A)this;
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").remove(builder); this.clusters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusters(Collection<GenericClusterReference> items) {
    if (this.clusters == null) return (A)this;
    for (GenericClusterReference item : items) {GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);_visitables.get("clusters").remove(builder); this.clusters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusters(Predicate<GenericClusterReferenceBuilder> predicate) {
    if (clusters == null) return (A) this;
    final Iterator<GenericClusterReferenceBuilder> each = clusters.iterator();
    final List visitables = _visitables.get("clusters");
    while (each.hasNext()) {
      GenericClusterReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GenericClusterReference> buildClusters() {
    return this.clusters != null ? build(clusters) : null;
  }
  
  public GenericClusterReference buildCluster(int index) {
    return this.clusters.get(index).build();
  }
  
  public GenericClusterReference buildFirstCluster() {
    return this.clusters.get(0).build();
  }
  
  public GenericClusterReference buildLastCluster() {
    return this.clusters.get(clusters.size() - 1).build();
  }
  
  public GenericClusterReference buildMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
      for (GenericClusterReferenceBuilder item : clusters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
      for (GenericClusterReferenceBuilder item : clusters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusters(List<GenericClusterReference> clusters) {
    if (this.clusters != null) {
      this._visitables.get("clusters").clear();
    }
    if (clusters != null) {
        this.clusters = new ArrayList();
        for (GenericClusterReference item : clusters) {
          this.addToClusters(item);
        }
    } else {
      this.clusters = null;
    }
    return (A) this;
  }
  
  public A withClusters(io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1.GenericClusterReference... clusters) {
    if (this.clusters != null) {
        this.clusters.clear();
        _visitables.remove("clusters");
    }
    if (clusters != null) {
      for (GenericClusterReference item : clusters) {
        this.addToClusters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusters() {
    return this.clusters != null && !this.clusters.isEmpty();
  }
  
  public A addNewCluster(String name) {
    return (A)addToClusters(new GenericClusterReference(name));
  }
  
  public ClustersNested<A> addNewCluster() {
    return new ClustersNested(-1, null);
  }
  
  public ClustersNested<A> addNewClusterLike(GenericClusterReference item) {
    return new ClustersNested(-1, item);
  }
  
  public ClustersNested<A> setNewClusterLike(int index,GenericClusterReference item) {
    return new ClustersNested(index, item);
  }
  
  public ClustersNested<A> editCluster(int index) {
    if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public ClustersNested<A> editFirstCluster() {
    if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
    return setNewClusterLike(0, buildCluster(0));
  }
  
  public ClustersNested<A> editLastCluster() {
    int index = clusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public ClustersNested<A> editMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusters.size();i++) { 
    if (predicate.test(clusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public A addToPolicies(int index,ObjectReference item) {
    if (this.policies == null) {this.policies = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= policies.size()) { _visitables.get("policies").add(builder); policies.add(builder); } else { _visitables.get("policies").add(index, builder); policies.add(index, builder);}
    return (A)this;
  }
  
  public A setToPolicies(int index,ObjectReference item) {
    if (this.policies == null) {this.policies = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= policies.size()) { _visitables.get("policies").add(builder); policies.add(builder); } else { _visitables.get("policies").set(index, builder); policies.set(index, builder);}
    return (A)this;
  }
  
  public A addToPolicies(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.policies == null) {this.policies = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("policies").add(builder);this.policies.add(builder);} return (A)this;
  }
  
  public A addAllToPolicies(Collection<ObjectReference> items) {
    if (this.policies == null) {this.policies = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("policies").add(builder);this.policies.add(builder);} return (A)this;
  }
  
  public A removeFromPolicies(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.policies == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("policies").remove(builder); this.policies.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPolicies(Collection<ObjectReference> items) {
    if (this.policies == null) return (A)this;
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("policies").remove(builder); this.policies.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPolicies(Predicate<ObjectReferenceBuilder> predicate) {
    if (policies == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = policies.iterator();
    final List visitables = _visitables.get("policies");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ObjectReference> buildPolicies() {
    return this.policies != null ? build(policies) : null;
  }
  
  public ObjectReference buildPolicy(int index) {
    return this.policies.get(index).build();
  }
  
  public ObjectReference buildFirstPolicy() {
    return this.policies.get(0).build();
  }
  
  public ObjectReference buildLastPolicy() {
    return this.policies.get(policies.size() - 1).build();
  }
  
  public ObjectReference buildMatchingPolicy(Predicate<ObjectReferenceBuilder> predicate) {
      for (ObjectReferenceBuilder item : policies) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPolicy(Predicate<ObjectReferenceBuilder> predicate) {
      for (ObjectReferenceBuilder item : policies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPolicies(List<ObjectReference> policies) {
    if (this.policies != null) {
      this._visitables.get("policies").clear();
    }
    if (policies != null) {
        this.policies = new ArrayList();
        for (ObjectReference item : policies) {
          this.addToPolicies(item);
        }
    } else {
      this.policies = null;
    }
    return (A) this;
  }
  
  public A withPolicies(io.fabric8.kubernetes.api.model.ObjectReference... policies) {
    if (this.policies != null) {
        this.policies.clear();
        _visitables.remove("policies");
    }
    if (policies != null) {
      for (ObjectReference item : policies) {
        this.addToPolicies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPolicies() {
    return this.policies != null && !this.policies.isEmpty();
  }
  
  public PoliciesNested<A> addNewPolicy() {
    return new PoliciesNested(-1, null);
  }
  
  public PoliciesNested<A> addNewPolicyLike(ObjectReference item) {
    return new PoliciesNested(-1, item);
  }
  
  public PoliciesNested<A> setNewPolicyLike(int index,ObjectReference item) {
    return new PoliciesNested(index, item);
  }
  
  public PoliciesNested<A> editPolicy(int index) {
    if (policies.size() <= index) throw new RuntimeException("Can't edit policies. Index exceeds size.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public PoliciesNested<A> editFirstPolicy() {
    if (policies.size() == 0) throw new RuntimeException("Can't edit first policies. The list is empty.");
    return setNewPolicyLike(0, buildPolicy(0));
  }
  
  public PoliciesNested<A> editLastPolicy() {
    int index = policies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last policies. The list is empty.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public PoliciesNested<A> editMatchingPolicy(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<policies.size();i++) { 
    if (predicate.test(policies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching policies. No match found.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public ResourceHint buildResourceHint() {
    return this.resourceHint != null ? this.resourceHint.build() : null;
  }
  
  public A withResourceHint(ResourceHint resourceHint) {
    this._visitables.remove("resourceHint");
    if (resourceHint != null) {
        this.resourceHint = new ResourceHintBuilder(resourceHint);
        this._visitables.get("resourceHint").add(this.resourceHint);
    } else {
        this.resourceHint = null;
        this._visitables.get("resourceHint").remove(this.resourceHint);
    }
    return (A) this;
  }
  
  public boolean hasResourceHint() {
    return this.resourceHint != null;
  }
  
  public A withNewResourceHint(String order,String type) {
    return (A)withResourceHint(new ResourceHint(order, type));
  }
  
  public ResourceHintNested<A> withNewResourceHint() {
    return new ResourceHintNested(null);
  }
  
  public ResourceHintNested<A> withNewResourceHintLike(ResourceHint item) {
    return new ResourceHintNested(item);
  }
  
  public ResourceHintNested<A> editResourceHint() {
    return withNewResourceHintLike(java.util.Optional.ofNullable(buildResourceHint()).orElse(null));
  }
  
  public ResourceHintNested<A> editOrNewResourceHint() {
    return withNewResourceHintLike(java.util.Optional.ofNullable(buildResourceHint()).orElse(new ResourceHintBuilder().build()));
  }
  
  public ResourceHintNested<A> editOrNewResourceHintLike(ResourceHint item) {
    return withNewResourceHintLike(java.util.Optional.ofNullable(buildResourceHint()).orElse(item));
  }
  
  public String getSchedulerName() {
    return this.schedulerName;
  }
  
  public A withSchedulerName(String schedulerName) {
    this.schedulerName = schedulerName;
    return (A) this;
  }
  
  public boolean hasSchedulerName() {
    return this.schedulerName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementRuleSpecFluent that = (PlacementRuleSpecFluent) o;
    if (!java.util.Objects.equals(clusterConditions, that.clusterConditions)) return false;
    if (!java.util.Objects.equals(clusterReplicas, that.clusterReplicas)) return false;
    if (!java.util.Objects.equals(clusterSelector, that.clusterSelector)) return false;
    if (!java.util.Objects.equals(clusters, that.clusters)) return false;
    if (!java.util.Objects.equals(policies, that.policies)) return false;
    if (!java.util.Objects.equals(resourceHint, that.resourceHint)) return false;
    if (!java.util.Objects.equals(schedulerName, that.schedulerName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterConditions,  clusterReplicas,  clusterSelector,  clusters,  policies,  resourceHint,  schedulerName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterConditions != null && !clusterConditions.isEmpty()) { sb.append("clusterConditions:"); sb.append(clusterConditions + ","); }
    if (clusterReplicas != null) { sb.append("clusterReplicas:"); sb.append(clusterReplicas + ","); }
    if (clusterSelector != null) { sb.append("clusterSelector:"); sb.append(clusterSelector + ","); }
    if (clusters != null && !clusters.isEmpty()) { sb.append("clusters:"); sb.append(clusters + ","); }
    if (policies != null && !policies.isEmpty()) { sb.append("policies:"); sb.append(policies + ","); }
    if (resourceHint != null) { sb.append("resourceHint:"); sb.append(resourceHint + ","); }
    if (schedulerName != null) { sb.append("schedulerName:"); sb.append(schedulerName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterConditionsNested<N> extends ClusterConditionFilterFluent<ClusterConditionsNested<N>> implements Nested<N>{
    ClusterConditionsNested(int index,ClusterConditionFilter item) {
      this.index = index;
      this.builder = new ClusterConditionFilterBuilder(this, item);
    }
    ClusterConditionFilterBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementRuleSpecFluent.this.setToClusterConditions(index,builder.build());
    }
    
    public N endClusterCondition() {
      return and();
    }
    
  
  }
  public class ClusterSelectorNested<N> extends LabelSelectorFluent<ClusterSelectorNested<N>> implements Nested<N>{
    ClusterSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) PlacementRuleSpecFluent.this.withClusterSelector(builder.build());
    }
    
    public N endClusterSelector() {
      return and();
    }
    
  
  }
  public class ClustersNested<N> extends GenericClusterReferenceFluent<ClustersNested<N>> implements Nested<N>{
    ClustersNested(int index,GenericClusterReference item) {
      this.index = index;
      this.builder = new GenericClusterReferenceBuilder(this, item);
    }
    GenericClusterReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementRuleSpecFluent.this.setToClusters(index,builder.build());
    }
    
    public N endCluster() {
      return and();
    }
    
  
  }
  public class PoliciesNested<N> extends ObjectReferenceFluent<PoliciesNested<N>> implements Nested<N>{
    PoliciesNested(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) PlacementRuleSpecFluent.this.setToPolicies(index,builder.build());
    }
    
    public N endPolicy() {
      return and();
    }
    
  
  }
  public class ResourceHintNested<N> extends ResourceHintFluent<ResourceHintNested<N>> implements Nested<N>{
    ResourceHintNested(ResourceHint item) {
      this.builder = new ResourceHintBuilder(this, item);
    }
    ResourceHintBuilder builder;
    
    public N and() {
      return (N) PlacementRuleSpecFluent.this.withResourceHint(builder.build());
    }
    
    public N endResourceHint() {
      return and();
    }
    
  
  }

}