package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GitOpsClusterSpecFluent<A extends GitOpsClusterSpecFluent<A>> extends BaseFluent<A>{
  public GitOpsClusterSpecFluent() {
  }
  
  public GitOpsClusterSpecFluent(GitOpsClusterSpec instance) {
    this.copyInstance(instance);
  }
  private ArgoServerSpecBuilder argoServer;
  private ObjectReferenceBuilder placementRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GitOpsClusterSpec instance) {
    instance = (instance != null ? instance : new GitOpsClusterSpec());
    if (instance != null) {
          this.withArgoServer(instance.getArgoServer());
          this.withPlacementRef(instance.getPlacementRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ArgoServerSpec buildArgoServer() {
    return this.argoServer != null ? this.argoServer.build() : null;
  }
  
  public A withArgoServer(ArgoServerSpec argoServer) {
    this._visitables.remove("argoServer");
    if (argoServer != null) {
        this.argoServer = new ArgoServerSpecBuilder(argoServer);
        this._visitables.get("argoServer").add(this.argoServer);
    } else {
        this.argoServer = null;
        this._visitables.get("argoServer").remove(this.argoServer);
    }
    return (A) this;
  }
  
  public boolean hasArgoServer() {
    return this.argoServer != null;
  }
  
  public A withNewArgoServer(String argoNamespace,String cluster) {
    return (A)withArgoServer(new ArgoServerSpec(argoNamespace, cluster));
  }
  
  public ArgoServerNested<A> withNewArgoServer() {
    return new ArgoServerNested(null);
  }
  
  public ArgoServerNested<A> withNewArgoServerLike(ArgoServerSpec item) {
    return new ArgoServerNested(item);
  }
  
  public ArgoServerNested<A> editArgoServer() {
    return withNewArgoServerLike(java.util.Optional.ofNullable(buildArgoServer()).orElse(null));
  }
  
  public ArgoServerNested<A> editOrNewArgoServer() {
    return withNewArgoServerLike(java.util.Optional.ofNullable(buildArgoServer()).orElse(new ArgoServerSpecBuilder().build()));
  }
  
  public ArgoServerNested<A> editOrNewArgoServerLike(ArgoServerSpec item) {
    return withNewArgoServerLike(java.util.Optional.ofNullable(buildArgoServer()).orElse(item));
  }
  
  public ObjectReference buildPlacementRef() {
    return this.placementRef != null ? this.placementRef.build() : null;
  }
  
  public A withPlacementRef(ObjectReference placementRef) {
    this._visitables.remove("placementRef");
    if (placementRef != null) {
        this.placementRef = new ObjectReferenceBuilder(placementRef);
        this._visitables.get("placementRef").add(this.placementRef);
    } else {
        this.placementRef = null;
        this._visitables.get("placementRef").remove(this.placementRef);
    }
    return (A) this;
  }
  
  public boolean hasPlacementRef() {
    return this.placementRef != null;
  }
  
  public PlacementRefNested<A> withNewPlacementRef() {
    return new PlacementRefNested(null);
  }
  
  public PlacementRefNested<A> withNewPlacementRefLike(ObjectReference item) {
    return new PlacementRefNested(item);
  }
  
  public PlacementRefNested<A> editPlacementRef() {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(null));
  }
  
  public PlacementRefNested<A> editOrNewPlacementRef() {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public PlacementRefNested<A> editOrNewPlacementRefLike(ObjectReference item) {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitOpsClusterSpecFluent that = (GitOpsClusterSpecFluent) o;
    if (!java.util.Objects.equals(argoServer, that.argoServer)) return false;
    if (!java.util.Objects.equals(placementRef, that.placementRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(argoServer,  placementRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (argoServer != null) { sb.append("argoServer:"); sb.append(argoServer + ","); }
    if (placementRef != null) { sb.append("placementRef:"); sb.append(placementRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ArgoServerNested<N> extends ArgoServerSpecFluent<ArgoServerNested<N>> implements Nested<N>{
    ArgoServerNested(ArgoServerSpec item) {
      this.builder = new ArgoServerSpecBuilder(this, item);
    }
    ArgoServerSpecBuilder builder;
    
    public N and() {
      return (N) GitOpsClusterSpecFluent.this.withArgoServer(builder.build());
    }
    
    public N endArgoServer() {
      return and();
    }
    
  
  }
  public class PlacementRefNested<N> extends ObjectReferenceFluent<PlacementRefNested<N>> implements Nested<N>{
    PlacementRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) GitOpsClusterSpecFluent.this.withPlacementRef(builder.build());
    }
    
    public N endPlacementRef() {
      return and();
    }
    
  
  }

}