package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GitOpsClusterSpecBuilder extends GitOpsClusterSpecFluent<GitOpsClusterSpecBuilder> implements VisitableBuilder<GitOpsClusterSpec,GitOpsClusterSpecBuilder>{
  public GitOpsClusterSpecBuilder() {
    this(new GitOpsClusterSpec());
  }
  
  public GitOpsClusterSpecBuilder(GitOpsClusterSpecFluent<?> fluent) {
    this(fluent, new GitOpsClusterSpec());
  }
  
  public GitOpsClusterSpecBuilder(GitOpsClusterSpecFluent<?> fluent,GitOpsClusterSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GitOpsClusterSpecBuilder(GitOpsClusterSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GitOpsClusterSpecFluent<?> fluent;
  
  public GitOpsClusterSpec build() {
    GitOpsClusterSpec buildable = new GitOpsClusterSpec(fluent.buildArgoServer(),fluent.buildPlacementRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}