package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GitOpsClusterBuilder extends GitOpsClusterFluent<GitOpsClusterBuilder> implements VisitableBuilder<GitOpsCluster,GitOpsClusterBuilder>{
  public GitOpsClusterBuilder() {
    this(new GitOpsCluster());
  }
  
  public GitOpsClusterBuilder(GitOpsClusterFluent<?> fluent) {
    this(fluent, new GitOpsCluster());
  }
  
  public GitOpsClusterBuilder(GitOpsClusterFluent<?> fluent,GitOpsCluster instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GitOpsClusterBuilder(GitOpsCluster instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GitOpsClusterFluent<?> fluent;
  
  public GitOpsCluster build() {
    GitOpsCluster buildable = new GitOpsCluster(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}