package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ArgoServerSpecBuilder extends ArgoServerSpecFluent<ArgoServerSpecBuilder> implements VisitableBuilder<ArgoServerSpec,ArgoServerSpecBuilder>{
  public ArgoServerSpecBuilder() {
    this(new ArgoServerSpec());
  }
  
  public ArgoServerSpecBuilder(ArgoServerSpecFluent<?> fluent) {
    this(fluent, new ArgoServerSpec());
  }
  
  public ArgoServerSpecBuilder(ArgoServerSpecFluent<?> fluent,ArgoServerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ArgoServerSpecBuilder(ArgoServerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ArgoServerSpecFluent<?> fluent;
  
  public ArgoServerSpec build() {
    ArgoServerSpec buildable = new ArgoServerSpec(fluent.getArgoNamespace(),fluent.getCluster());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}