package io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceHintBuilder extends ResourceHintFluent<ResourceHintBuilder> implements VisitableBuilder<ResourceHint,ResourceHintBuilder>{
  public ResourceHintBuilder() {
    this(false);
  }
  public ResourceHintBuilder(Boolean validationEnabled) {
    this(new ResourceHint(), validationEnabled);
  }
  public ResourceHintBuilder(ResourceHintFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceHintBuilder(ResourceHintFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceHint(), validationEnabled);
  }
  public ResourceHintBuilder(ResourceHintFluent<?> fluent,ResourceHint instance) {
    this(fluent, instance, false);
  }
  public ResourceHintBuilder(ResourceHintFluent<?> fluent,ResourceHint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceHint());

    if (instance != null) {
      fluent.withOrder(instance.getOrder());
      fluent.withType(instance.getType());
      fluent.withOrder(instance.getOrder());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceHintBuilder(ResourceHint instance) {
    this(instance,false);
  }
  public ResourceHintBuilder(ResourceHint instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceHint());

    if (instance != null) {
      this.withOrder(instance.getOrder());
      this.withType(instance.getType());
      this.withOrder(instance.getOrder());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceHintFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceHint build() {
    ResourceHint buildable = new ResourceHint(fluent.getOrder(),fluent.getType());
    return buildable;
  }
  
}