package io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementRuleSpecBuilder extends PlacementRuleSpecFluent<PlacementRuleSpecBuilder> implements VisitableBuilder<PlacementRuleSpec,PlacementRuleSpecBuilder>{
  public PlacementRuleSpecBuilder() {
    this(false);
  }
  public PlacementRuleSpecBuilder(Boolean validationEnabled) {
    this(new PlacementRuleSpec(), validationEnabled);
  }
  public PlacementRuleSpecBuilder(PlacementRuleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementRuleSpecBuilder(PlacementRuleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementRuleSpec(), validationEnabled);
  }
  public PlacementRuleSpecBuilder(PlacementRuleSpecFluent<?> fluent,PlacementRuleSpec instance) {
    this(fluent, instance, false);
  }
  public PlacementRuleSpecBuilder(PlacementRuleSpecFluent<?> fluent,PlacementRuleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PlacementRuleSpec());

    if (instance != null) {
      fluent.withClusterConditions(instance.getClusterConditions());
      fluent.withClusterReplicas(instance.getClusterReplicas());
      fluent.withClusterSelector(instance.getClusterSelector());
      fluent.withClusters(instance.getClusters());
      fluent.withPolicies(instance.getPolicies());
      fluent.withResourceHint(instance.getResourceHint());
      fluent.withSchedulerName(instance.getSchedulerName());
      fluent.withClusterConditions(instance.getClusterConditions());
      fluent.withClusterReplicas(instance.getClusterReplicas());
      fluent.withClusterSelector(instance.getClusterSelector());
      fluent.withClusters(instance.getClusters());
      fluent.withPolicies(instance.getPolicies());
      fluent.withResourceHint(instance.getResourceHint());
      fluent.withSchedulerName(instance.getSchedulerName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlacementRuleSpecBuilder(PlacementRuleSpec instance) {
    this(instance,false);
  }
  public PlacementRuleSpecBuilder(PlacementRuleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PlacementRuleSpec());

    if (instance != null) {
      this.withClusterConditions(instance.getClusterConditions());
      this.withClusterReplicas(instance.getClusterReplicas());
      this.withClusterSelector(instance.getClusterSelector());
      this.withClusters(instance.getClusters());
      this.withPolicies(instance.getPolicies());
      this.withResourceHint(instance.getResourceHint());
      this.withSchedulerName(instance.getSchedulerName());
      this.withClusterConditions(instance.getClusterConditions());
      this.withClusterReplicas(instance.getClusterReplicas());
      this.withClusterSelector(instance.getClusterSelector());
      this.withClusters(instance.getClusters());
      this.withPolicies(instance.getPolicies());
      this.withResourceHint(instance.getResourceHint());
      this.withSchedulerName(instance.getSchedulerName());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlacementRuleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementRuleSpec build() {
    PlacementRuleSpec buildable = new PlacementRuleSpec(fluent.buildClusterConditions(),fluent.getClusterReplicas(),fluent.buildClusterSelector(),fluent.buildClusters(),fluent.buildPolicies(),fluent.buildResourceHint(),fluent.getSchedulerName());
    return buildable;
  }
  
}