package io.fabric8.openclustermanagement.api.model.multicloudoperatorsplacementrule.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementRuleBuilder extends PlacementRuleFluent<PlacementRuleBuilder> implements VisitableBuilder<PlacementRule,PlacementRuleBuilder>{
  public PlacementRuleBuilder() {
    this(false);
  }
  public PlacementRuleBuilder(Boolean validationEnabled) {
    this(new PlacementRule(), validationEnabled);
  }
  public PlacementRuleBuilder(PlacementRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementRuleBuilder(PlacementRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementRule(), validationEnabled);
  }
  public PlacementRuleBuilder(PlacementRuleFluent<?> fluent,PlacementRule instance) {
    this(fluent, instance, false);
  }
  public PlacementRuleBuilder(PlacementRuleFluent<?> fluent,PlacementRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PlacementRule());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlacementRuleBuilder(PlacementRule instance) {
    this(instance,false);
  }
  public PlacementRuleBuilder(PlacementRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PlacementRule());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlacementRuleFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementRule build() {
    PlacementRule buildable = new PlacementRule(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}