package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitOpsClusterSpecFluent<A extends GitOpsClusterSpecFluent<A>> extends BaseFluent<A>{
  public GitOpsClusterSpecFluent() {
  }
  public GitOpsClusterSpecFluent(GitOpsClusterSpec instance) {
    instance = (instance != null ? instance : new GitOpsClusterSpec());

    if (instance != null) {
      this.withArgoServer(instance.getArgoServer());
      this.withPlacementRef(instance.getPlacementRef());
      this.withArgoServer(instance.getArgoServer());
      this.withPlacementRef(instance.getPlacementRef());
    }
  }
  private ArgoServerSpecBuilder argoServer;
  private ObjectReferenceBuilder placementRef;
  public ArgoServerSpec buildArgoServer() {
    return this.argoServer!=null ?this.argoServer.build():null;
  }
  public A withArgoServer(ArgoServerSpec argoServer) {
    _visitables.get("argoServer").remove(this.argoServer);
    if (argoServer!=null){ this.argoServer= new ArgoServerSpecBuilder(argoServer); _visitables.get("argoServer").add(this.argoServer);} else { this.argoServer = null; _visitables.get("argoServer").remove(this.argoServer); } return (A) this;
  }
  public boolean hasArgoServer() {
    return this.argoServer != null;
  }
  public A withNewArgoServer(String argoNamespace,String cluster) {
    return (A)withArgoServer(new ArgoServerSpec(argoNamespace, cluster));
  }
  public ArgoServerNested<A> withNewArgoServer() {
    return new ArgoServerNested(null);
  }
  public ArgoServerNested<A> withNewArgoServerLike(ArgoServerSpec item) {
    return new ArgoServerNested(item);
  }
  public ArgoServerNested<A> editArgoServer() {
    return withNewArgoServerLike(java.util.Optional.ofNullable(buildArgoServer()).orElse(null));
  }
  public ArgoServerNested<A> editOrNewArgoServer() {
    return withNewArgoServerLike(java.util.Optional.ofNullable(buildArgoServer()).orElse(new ArgoServerSpecBuilder().build()));
  }
  public ArgoServerNested<A> editOrNewArgoServerLike(ArgoServerSpec item) {
    return withNewArgoServerLike(java.util.Optional.ofNullable(buildArgoServer()).orElse(item));
  }
  public ObjectReference buildPlacementRef() {
    return this.placementRef!=null ?this.placementRef.build():null;
  }
  public A withPlacementRef(ObjectReference placementRef) {
    _visitables.get("placementRef").remove(this.placementRef);
    if (placementRef!=null){ this.placementRef= new ObjectReferenceBuilder(placementRef); _visitables.get("placementRef").add(this.placementRef);} else { this.placementRef = null; _visitables.get("placementRef").remove(this.placementRef); } return (A) this;
  }
  public boolean hasPlacementRef() {
    return this.placementRef != null;
  }
  public PlacementRefNested<A> withNewPlacementRef() {
    return new PlacementRefNested(null);
  }
  public PlacementRefNested<A> withNewPlacementRefLike(ObjectReference item) {
    return new PlacementRefNested(item);
  }
  public PlacementRefNested<A> editPlacementRef() {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(null));
  }
  public PlacementRefNested<A> editOrNewPlacementRef() {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  public PlacementRefNested<A> editOrNewPlacementRefLike(ObjectReference item) {
    return withNewPlacementRefLike(java.util.Optional.ofNullable(buildPlacementRef()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitOpsClusterSpecFluent that = (GitOpsClusterSpecFluent) o;
    if (!java.util.Objects.equals(argoServer, that.argoServer)) return false;

    if (!java.util.Objects.equals(placementRef, that.placementRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(argoServer,  placementRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (argoServer != null) { sb.append("argoServer:"); sb.append(argoServer + ","); }
    if (placementRef != null) { sb.append("placementRef:"); sb.append(placementRef); }
    sb.append("}");
    return sb.toString();
  }
  public class ArgoServerNested<N> extends ArgoServerSpecFluent<ArgoServerNested<N>> implements Nested<N>{
    ArgoServerNested(ArgoServerSpec item) {
      this.builder = new ArgoServerSpecBuilder(this, item);
    }
    ArgoServerSpecBuilder builder;
    public N and() {
      return (N) GitOpsClusterSpecFluent.this.withArgoServer(builder.build());
    }
    public N endArgoServer() {
      return and();
    }
    
  }
  public class PlacementRefNested<N> extends ObjectReferenceFluent<PlacementRefNested<N>> implements Nested<N>{
    PlacementRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) GitOpsClusterSpecFluent.this.withPlacementRef(builder.build());
    }
    public N endPlacementRef() {
      return and();
    }
    
  }
  
}