package io.fabric8.openclustermanagement.api.model.multicloudintegration.apps.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitOpsClusterBuilder extends GitOpsClusterFluent<GitOpsClusterBuilder> implements VisitableBuilder<GitOpsCluster,GitOpsClusterBuilder>{
  public GitOpsClusterBuilder() {
    this(false);
  }
  public GitOpsClusterBuilder(Boolean validationEnabled) {
    this(new GitOpsCluster(), validationEnabled);
  }
  public GitOpsClusterBuilder(GitOpsClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public GitOpsClusterBuilder(GitOpsClusterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitOpsCluster(), validationEnabled);
  }
  public GitOpsClusterBuilder(GitOpsClusterFluent<?> fluent,GitOpsCluster instance) {
    this(fluent, instance, false);
  }
  public GitOpsClusterBuilder(GitOpsClusterFluent<?> fluent,GitOpsCluster instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitOpsCluster());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitOpsClusterBuilder(GitOpsCluster instance) {
    this(instance,false);
  }
  public GitOpsClusterBuilder(GitOpsCluster instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitOpsCluster());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitOpsClusterFluent<?> fluent;
  Boolean validationEnabled;
  public GitOpsCluster build() {
    GitOpsCluster buildable = new GitOpsCluster(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}