package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceListBuilder extends ServiceListFluent<ServiceListBuilder> implements VisitableBuilder<ServiceList,ServiceListBuilder>{
  public ServiceListBuilder() {
    this(new ServiceList());
  }
  
  public ServiceListBuilder(ServiceListFluent<?> fluent) {
    this(fluent, new ServiceList());
  }
  
  public ServiceListBuilder(ServiceListFluent<?> fluent,ServiceList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceListBuilder(ServiceList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceListFluent<?> fluent;
  
  public ServiceList build() {
    ServiceList buildable = new ServiceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}