package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretProjectionBuilder extends SecretProjectionFluent<SecretProjectionBuilder> implements VisitableBuilder<SecretProjection,SecretProjectionBuilder>{
  public SecretProjectionBuilder() {
    this(new SecretProjection());
  }
  
  public SecretProjectionBuilder(SecretProjectionFluent<?> fluent) {
    this(fluent, new SecretProjection());
  }
  
  public SecretProjectionBuilder(SecretProjectionFluent<?> fluent,SecretProjection instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretProjectionBuilder(SecretProjection instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretProjectionFluent<?> fluent;
  
  public SecretProjection build() {
    SecretProjection buildable = new SecretProjection(fluent.buildItems(),fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}