package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MicroTimeBuilder extends MicroTimeFluent<MicroTimeBuilder> implements VisitableBuilder<MicroTime,MicroTimeBuilder>{
  public MicroTimeBuilder() {
    this(new MicroTime());
  }
  
  public MicroTimeBuilder(MicroTimeFluent<?> fluent) {
    this(fluent, new MicroTime());
  }
  
  public MicroTimeBuilder(MicroTimeFluent<?> fluent,MicroTime instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MicroTimeBuilder(MicroTime instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MicroTimeFluent<?> fluent;
  
  public MicroTime build() {
    MicroTime buildable = new MicroTime(fluent.getTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}