package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ListOptionsFluent<A extends ListOptionsFluent<A>> extends BaseFluent<A>{
  public ListOptionsFluent() {
  }
  
  public ListOptionsFluent(ListOptions instance) {
    this.copyInstance(instance);
  }
  private Boolean allowWatchBookmarks;
  private String apiVersion;
  private String _continue;
  private String fieldSelector;
  private String kind;
  private String labelSelector;
  private Long limit;
  private String resourceVersion;
  private String resourceVersionMatch;
  private Boolean sendInitialEvents;
  private Long timeoutSeconds;
  private Boolean watch;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ListOptions instance) {
    instance = (instance != null ? instance : new ListOptions());
    if (instance != null) {
          this.withAllowWatchBookmarks(instance.getAllowWatchBookmarks());
          this.withApiVersion(instance.getApiVersion());
          this.withContinue(instance.getContinue());
          this.withFieldSelector(instance.getFieldSelector());
          this.withKind(instance.getKind());
          this.withLabelSelector(instance.getLabelSelector());
          this.withLimit(instance.getLimit());
          this.withResourceVersion(instance.getResourceVersion());
          this.withResourceVersionMatch(instance.getResourceVersionMatch());
          this.withSendInitialEvents(instance.getSendInitialEvents());
          this.withTimeoutSeconds(instance.getTimeoutSeconds());
          this.withWatch(instance.getWatch());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getAllowWatchBookmarks() {
    return this.allowWatchBookmarks;
  }
  
  public A withAllowWatchBookmarks(Boolean allowWatchBookmarks) {
    this.allowWatchBookmarks = allowWatchBookmarks;
    return (A) this;
  }
  
  public boolean hasAllowWatchBookmarks() {
    return this.allowWatchBookmarks != null;
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getContinue() {
    return this._continue;
  }
  
  public A withContinue(String _continue) {
    this._continue = _continue;
    return (A) this;
  }
  
  public boolean hasContinue() {
    return this._continue != null;
  }
  
  public String getFieldSelector() {
    return this.fieldSelector;
  }
  
  public A withFieldSelector(String fieldSelector) {
    this.fieldSelector = fieldSelector;
    return (A) this;
  }
  
  public boolean hasFieldSelector() {
    return this.fieldSelector != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getLabelSelector() {
    return this.labelSelector;
  }
  
  public A withLabelSelector(String labelSelector) {
    this.labelSelector = labelSelector;
    return (A) this;
  }
  
  public boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  
  public Long getLimit() {
    return this.limit;
  }
  
  public A withLimit(Long limit) {
    this.limit = limit;
    return (A) this;
  }
  
  public boolean hasLimit() {
    return this.limit != null;
  }
  
  public String getResourceVersion() {
    return this.resourceVersion;
  }
  
  public A withResourceVersion(String resourceVersion) {
    this.resourceVersion = resourceVersion;
    return (A) this;
  }
  
  public boolean hasResourceVersion() {
    return this.resourceVersion != null;
  }
  
  public String getResourceVersionMatch() {
    return this.resourceVersionMatch;
  }
  
  public A withResourceVersionMatch(String resourceVersionMatch) {
    this.resourceVersionMatch = resourceVersionMatch;
    return (A) this;
  }
  
  public boolean hasResourceVersionMatch() {
    return this.resourceVersionMatch != null;
  }
  
  public Boolean getSendInitialEvents() {
    return this.sendInitialEvents;
  }
  
  public A withSendInitialEvents(Boolean sendInitialEvents) {
    this.sendInitialEvents = sendInitialEvents;
    return (A) this;
  }
  
  public boolean hasSendInitialEvents() {
    return this.sendInitialEvents != null;
  }
  
  public Long getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  
  public A withTimeoutSeconds(Long timeoutSeconds) {
    this.timeoutSeconds = timeoutSeconds;
    return (A) this;
  }
  
  public boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  
  public Boolean getWatch() {
    return this.watch;
  }
  
  public A withWatch(Boolean watch) {
    this.watch = watch;
    return (A) this;
  }
  
  public boolean hasWatch() {
    return this.watch != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ListOptionsFluent that = (ListOptionsFluent) o;
    if (!java.util.Objects.equals(allowWatchBookmarks, that.allowWatchBookmarks)) return false;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(_continue, that._continue)) return false;
    if (!java.util.Objects.equals(fieldSelector, that.fieldSelector)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;
    if (!java.util.Objects.equals(limit, that.limit)) return false;
    if (!java.util.Objects.equals(resourceVersion, that.resourceVersion)) return false;
    if (!java.util.Objects.equals(resourceVersionMatch, that.resourceVersionMatch)) return false;
    if (!java.util.Objects.equals(sendInitialEvents, that.sendInitialEvents)) return false;
    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;
    if (!java.util.Objects.equals(watch, that.watch)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allowWatchBookmarks,  apiVersion,  _continue,  fieldSelector,  kind,  labelSelector,  limit,  resourceVersion,  resourceVersionMatch,  sendInitialEvents,  timeoutSeconds,  watch,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowWatchBookmarks != null) { sb.append("allowWatchBookmarks:"); sb.append(allowWatchBookmarks + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (_continue != null) { sb.append("_continue:"); sb.append(_continue + ","); }
    if (fieldSelector != null) { sb.append("fieldSelector:"); sb.append(fieldSelector + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (limit != null) { sb.append("limit:"); sb.append(limit + ","); }
    if (resourceVersion != null) { sb.append("resourceVersion:"); sb.append(resourceVersion + ","); }
    if (resourceVersionMatch != null) { sb.append("resourceVersionMatch:"); sb.append(resourceVersionMatch + ","); }
    if (sendInitialEvents != null) { sb.append("sendInitialEvents:"); sb.append(sendInitialEvents + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (watch != null) { sb.append("watch:"); sb.append(watch + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAllowWatchBookmarks() {
    return withAllowWatchBookmarks(true);
  }
  
  public A withSendInitialEvents() {
    return withSendInitialEvents(true);
  }
  
  public A withWatch() {
    return withWatch(true);
  }
  

}