package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AuthProviderConfigBuilder extends AuthProviderConfigFluent<AuthProviderConfigBuilder> implements VisitableBuilder<AuthProviderConfig,AuthProviderConfigBuilder>{
  public AuthProviderConfigBuilder() {
    this(new AuthProviderConfig());
  }
  
  public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent) {
    this(fluent, new AuthProviderConfig());
  }
  
  public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent,AuthProviderConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AuthProviderConfigBuilder(AuthProviderConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AuthProviderConfigFluent<?> fluent;
  
  public AuthProviderConfig build() {
    AuthProviderConfig buildable = new AuthProviderConfig(fluent.getConfig(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}