package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

public interface SecurityContextFluent<A extends SecurityContextFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Boolean getAllowPrivilegeEscalation();
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation);
    public Boolean hasAllowPrivilegeEscalation();
    public A withNewAllowPrivilegeEscalation(String arg1);
    public A withNewAllowPrivilegeEscalation(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildCapabilities instead.
 * @return The buildable object.
 */
@Deprecated public Capabilities getCapabilities();
    public Capabilities buildCapabilities();
    public A withCapabilities(Capabilities capabilities);
    public Boolean hasCapabilities();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item);
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> editCapabilities();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item);
    public Boolean getPrivileged();
    public A withPrivileged(Boolean privileged);
    public Boolean hasPrivileged();
    public A withNewPrivileged(String arg1);
    public A withNewPrivileged(boolean arg1);
    public String getProcMount();
    public A withProcMount(String procMount);
    public Boolean hasProcMount();
    public A withNewProcMount(StringBuilder arg1);
    public A withNewProcMount(int[] arg1,int arg2,int arg3);
    public A withNewProcMount(char[] arg1);
    public A withNewProcMount(StringBuffer arg1);
    public A withNewProcMount(byte[] arg1,int arg2);
    public A withNewProcMount(byte[] arg1);
    public A withNewProcMount(char[] arg1,int arg2,int arg3);
    public A withNewProcMount(byte[] arg1,int arg2,int arg3);
    public A withNewProcMount(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewProcMount(String arg1);
    public Boolean getReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public Boolean hasReadOnlyRootFilesystem();
    public A withNewReadOnlyRootFilesystem(String arg1);
    public A withNewReadOnlyRootFilesystem(boolean arg1);
    public Long getRunAsGroup();
    public A withRunAsGroup(Long runAsGroup);
    public Boolean hasRunAsGroup();
    public A withNewRunAsGroup(long arg1);
    public Boolean getRunAsNonRoot();
    public A withRunAsNonRoot(Boolean runAsNonRoot);
    public Boolean hasRunAsNonRoot();
    public A withNewRunAsNonRoot(String arg1);
    public A withNewRunAsNonRoot(boolean arg1);
    public Long getRunAsUser();
    public A withRunAsUser(Long runAsUser);
    public Boolean hasRunAsUser();
    public A withNewRunAsUser(long arg1);
    
/**
 * This method has been deprecated, please use method buildSeLinuxOptions instead.
 * @return The buildable object.
 */
@Deprecated public SELinuxOptions getSeLinuxOptions();
    public SELinuxOptions buildSeLinuxOptions();
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions);
    public Boolean hasSeLinuxOptions();
    public A withNewSeLinuxOptions(String level,String role,String type,String user);
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item);
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item);
    
/**
 * This method has been deprecated, please use method buildSeccompProfile instead.
 * @return The buildable object.
 */
@Deprecated public SeccompProfile getSeccompProfile();
    public SeccompProfile buildSeccompProfile();
    public A withSeccompProfile(SeccompProfile seccompProfile);
    public Boolean hasSeccompProfile();
    public A withNewSeccompProfile(String localhostProfile,String type);
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item);
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> editSeccompProfile();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item);
    
/**
 * This method has been deprecated, please use method buildWindowsOptions instead.
 * @return The buildable object.
 */
@Deprecated public WindowsSecurityContextOptions getWindowsOptions();
    public WindowsSecurityContextOptions buildWindowsOptions();
    public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions);
    public Boolean hasWindowsOptions();
    public A withNewWindowsOptions(String gmsaCredentialSpec,String gmsaCredentialSpecName,String runAsUserName);
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item);
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions();
    public io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item);
    public interface CapabilitiesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CapabilitiesFluent<io.fabric8.kubernetes.api.model.SecurityContextFluent.CapabilitiesNested<N>> {

            public N and();
            public N endCapabilities();    }


    public interface SeLinuxOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SELinuxOptionsFluent<io.fabric8.kubernetes.api.model.SecurityContextFluent.SeLinuxOptionsNested<N>> {

            public N and();
            public N endSeLinuxOptions();    }


    public interface SeccompProfileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SeccompProfileFluent<io.fabric8.kubernetes.api.model.SecurityContextFluent.SeccompProfileNested<N>> {

            public N and();
            public N endSeccompProfile();    }


    public interface WindowsOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,WindowsSecurityContextOptionsFluent<io.fabric8.kubernetes.api.model.SecurityContextFluent.WindowsOptionsNested<N>> {

            public N and();
            public N endWindowsOptions();    }


}
