package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodIPBuilder extends PodIPFluentImpl<PodIPBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PodIP,PodIPBuilder> {

    PodIPFluent<?> fluent;
    Boolean validationEnabled;

    public PodIPBuilder() {
        this(true);
    }

    public PodIPBuilder(Boolean validationEnabled) {
        this(new PodIP(), validationEnabled);
    }

    public PodIPBuilder(PodIPFluent<?> fluent) {
        this(fluent, true);
    }

    public PodIPBuilder(PodIPFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodIP(), validationEnabled);
    }

    public PodIPBuilder(PodIPFluent<?> fluent,PodIP instance) {
        this(fluent, instance, true);
    }

    public PodIPBuilder(PodIPFluent<?> fluent,PodIP instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withIp(instance.getIp()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodIPBuilder(PodIP instance) {
        this(instance,true);
    }

    public PodIPBuilder(PodIP instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withIp(instance.getIp()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodIP build() {
        PodIP buildable = new PodIP(fluent.getIp());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodIPBuilder that = (PodIPBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
