package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ContextFluentImpl<A extends ContextFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ContextFluent<A> {

    private String cluster;
    private List<NamedExtensionBuilder> extensions =  new ArrayList<NamedExtensionBuilder>();
    private String namespace;
    private String user;

    public ContextFluentImpl() {
    }

    public ContextFluentImpl(Context instance) {
        this.withCluster(instance.getCluster()); 
        this.withExtensions(instance.getExtensions()); 
        this.withNamespace(instance.getNamespace()); 
        this.withUser(instance.getUser()); 
    }

    public String getCluster() {
        return this.cluster;
    }

    public A withCluster(String cluster) {
        this.cluster=cluster; return (A) this;
    }

    public Boolean hasCluster() {
        return this.cluster != null;
    }

    public A withNewCluster(StringBuilder arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(int[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(char[] arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(StringBuffer arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(byte[] arg1,int arg2) {
        return (A)withCluster(new String(arg1, arg2));
    }

    public A withNewCluster(byte[] arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(char[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(byte[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCluster(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCluster(String arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A addToExtensions(int index,NamedExtension item) {
        if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(index >= 0 ? index : _visitables.get("extensions").size(), builder);this.extensions.add(index >= 0 ? index : extensions.size(), builder); return (A)this;
    }

    public A setToExtensions(int index,NamedExtension item) {
        if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= _visitables.get("extensions").size()) { _visitables.get("extensions").add(builder); } else { _visitables.get("extensions").set(index, builder);}
        if (index < 0 || index >= extensions.size()) { extensions.add(builder); } else { extensions.set(index, builder);}
         return (A)this;
    }

    public A addToExtensions(NamedExtension... items) {
        if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
        for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
        for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A removeFromExtensions(NamedExtension... items) {
        for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
    }

    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (extensions == null) return (A) this;
        final Iterator<NamedExtensionBuilder> each = extensions.iterator();
        final List visitables = _visitables.get("extensions");
        while (each.hasNext()) {
          NamedExtensionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildExtensions instead.
 * @return The buildable object.
 */
@Deprecated public List<NamedExtension> getExtensions() {
        return build(extensions);
    }

    public List<NamedExtension> buildExtensions() {
        return build(extensions);
    }

    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    public NamedExtension buildLastExtension() {
        return this.extensions.get(extensions.size() - 1).build();
    }

    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) { _visitables.get("extensions").removeAll(this.extensions);}
        if (extensions != null) {this.extensions = new ArrayList<NamedExtensionBuilder>(); for (NamedExtension item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
    }

    public A withExtensions(NamedExtension... extensions) {
        if (this.extensions != null) {this.extensions.clear();}
        if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
    }

    public Boolean hasExtensions() {
        return extensions != null && !extensions.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<A> setNewExtensionLike(int index,NamedExtension item) {
        return new ExtensionsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<A> editExtension(int index) {
        if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        return setNewExtensionLike(index, buildExtension(index));
    }

    public io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<A> editFirstExtension() {
        if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
        return setNewExtensionLike(0, buildExtension(0));
    }

    public io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<A> editLastExtension() {
        int index = extensions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
        return setNewExtensionLike(index, buildExtension(index));
    }

    public io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<extensions.size();i++) { 
        if (predicate.test(extensions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
        return setNewExtensionLike(index, buildExtension(index));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public A withNewNamespace(StringBuilder arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(int[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(char[] arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(byte[] arg1,int arg2) {
        return (A)withNamespace(new String(arg1, arg2));
    }

    public A withNewNamespace(byte[] arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(char[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(byte[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withNamespace(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewNamespace(String arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user=user; return (A) this;
    }

    public Boolean hasUser() {
        return this.user != null;
    }

    public A withNewUser(StringBuilder arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(int[] arg1,int arg2,int arg3) {
        return (A)withUser(new String(arg1, arg2, arg3));
    }

    public A withNewUser(char[] arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(byte[] arg1,int arg2) {
        return (A)withUser(new String(arg1, arg2));
    }

    public A withNewUser(byte[] arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(char[] arg1,int arg2,int arg3) {
        return (A)withUser(new String(arg1, arg2, arg3));
    }

    public A withNewUser(byte[] arg1,int arg2,int arg3) {
        return (A)withUser(new String(arg1, arg2, arg3));
    }

    public A withNewUser(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUser(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUser(String arg1) {
        return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ContextFluentImpl that = (ContextFluentImpl) o;
        if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
        if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(cluster,  extensions,  namespace,  user,  super.hashCode());
    }

    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<N>> implements io.fabric8.kubernetes.api.model.ContextFluent.ExtensionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamedExtensionBuilder builder;
        private final int index;

            ExtensionsNestedImpl(int index,NamedExtension item) {
                this.index = index;
                this.builder = new NamedExtensionBuilder(this, item);
                        
            }

            ExtensionsNestedImpl() {
                this.index = -1;
                this.builder = new NamedExtensionBuilder(this);
                        
            }

            public N and() {
                return (N) ContextFluentImpl.this.setToExtensions(index,builder.build());
            }

            public N endExtension() {
                return and();
            }
    }


}
