package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TopologySpreadConstraintBuilder extends TopologySpreadConstraintFluentImpl<TopologySpreadConstraintBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<TopologySpreadConstraint,TopologySpreadConstraintBuilder> {

    TopologySpreadConstraintFluent<?> fluent;
    Boolean validationEnabled;

    public TopologySpreadConstraintBuilder() {
        this(true);
    }

    public TopologySpreadConstraintBuilder(Boolean validationEnabled) {
        this(new TopologySpreadConstraint(), validationEnabled);
    }

    public TopologySpreadConstraintBuilder(TopologySpreadConstraintFluent<?> fluent) {
        this(fluent, true);
    }

    public TopologySpreadConstraintBuilder(TopologySpreadConstraintFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TopologySpreadConstraint(), validationEnabled);
    }

    public TopologySpreadConstraintBuilder(TopologySpreadConstraintFluent<?> fluent,TopologySpreadConstraint instance) {
        this(fluent, instance, true);
    }

    public TopologySpreadConstraintBuilder(TopologySpreadConstraintFluent<?> fluent,TopologySpreadConstraint instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLabelSelector(instance.getLabelSelector()); 
        fluent.withMaxSkew(instance.getMaxSkew()); 
        fluent.withTopologyKey(instance.getTopologyKey()); 
        fluent.withWhenUnsatisfiable(instance.getWhenUnsatisfiable()); 
        this.validationEnabled = validationEnabled; 
    }

    public TopologySpreadConstraintBuilder(TopologySpreadConstraint instance) {
        this(instance,true);
    }

    public TopologySpreadConstraintBuilder(TopologySpreadConstraint instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLabelSelector(instance.getLabelSelector()); 
        this.withMaxSkew(instance.getMaxSkew()); 
        this.withTopologyKey(instance.getTopologyKey()); 
        this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable()); 
        this.validationEnabled = validationEnabled; 
    }

    public TopologySpreadConstraint build() {
        TopologySpreadConstraint buildable = new TopologySpreadConstraint(fluent.getLabelSelector(),fluent.getMaxSkew(),fluent.getTopologyKey(),fluent.getWhenUnsatisfiable());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TopologySpreadConstraintBuilder that = (TopologySpreadConstraintBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
