package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SeccompProfileFluentImpl<A extends SeccompProfileFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SeccompProfileFluent<A> {

    private String localhostProfile;
    private String type;

    public SeccompProfileFluentImpl() {
    }

    public SeccompProfileFluentImpl(SeccompProfile instance) {
        this.withLocalhostProfile(instance.getLocalhostProfile()); 
        this.withType(instance.getType()); 
    }

    public String getLocalhostProfile() {
        return this.localhostProfile;
    }

    public A withLocalhostProfile(String localhostProfile) {
        this.localhostProfile=localhostProfile; return (A) this;
    }

    public Boolean hasLocalhostProfile() {
        return this.localhostProfile != null;
    }

    public A withNewLocalhostProfile(StringBuilder arg1) {
        return (A)withLocalhostProfile(new String(arg1));
    }

    public A withNewLocalhostProfile(int[] arg1,int arg2,int arg3) {
        return (A)withLocalhostProfile(new String(arg1, arg2, arg3));
    }

    public A withNewLocalhostProfile(char[] arg1) {
        return (A)withLocalhostProfile(new String(arg1));
    }

    public A withNewLocalhostProfile(StringBuffer arg1) {
        return (A)withLocalhostProfile(new String(arg1));
    }

    public A withNewLocalhostProfile(byte[] arg1,int arg2) {
        return (A)withLocalhostProfile(new String(arg1, arg2));
    }

    public A withNewLocalhostProfile(byte[] arg1) {
        return (A)withLocalhostProfile(new String(arg1));
    }

    public A withNewLocalhostProfile(char[] arg1,int arg2,int arg3) {
        return (A)withLocalhostProfile(new String(arg1, arg2, arg3));
    }

    public A withNewLocalhostProfile(byte[] arg1,int arg2,int arg3) {
        return (A)withLocalhostProfile(new String(arg1, arg2, arg3));
    }

    public A withNewLocalhostProfile(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLocalhostProfile(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLocalhostProfile(String arg1) {
        return (A)withLocalhostProfile(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SeccompProfileFluentImpl that = (SeccompProfileFluentImpl) o;
        if (localhostProfile != null ? !localhostProfile.equals(that.localhostProfile) :that.localhostProfile != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(localhostProfile,  type,  super.hashCode());
    }

}
