package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodBuilder extends PodFluentImpl<PodBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Pod,PodBuilder> {

    PodFluent<?> fluent;
    Boolean validationEnabled;

    public PodBuilder() {
        this(true);
    }

    public PodBuilder(Boolean validationEnabled) {
        this(new Pod(), validationEnabled);
    }

    public PodBuilder(PodFluent<?> fluent) {
        this(fluent, true);
    }

    public PodBuilder(PodFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Pod(), validationEnabled);
    }

    public PodBuilder(PodFluent<?> fluent,Pod instance) {
        this(fluent, instance, true);
    }

    public PodBuilder(PodFluent<?> fluent,Pod instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodBuilder(Pod instance) {
        this(instance,true);
    }

    public PodBuilder(Pod instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public Pod build() {
        Pod buildable = new Pod(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodBuilder that = (PodBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
