package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class NodeSystemInfoFluentImpl<A extends NodeSystemInfoFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodeSystemInfoFluent<A> {

    private String architecture;
    private String bootID;
    private String containerRuntimeVersion;
    private String kernelVersion;
    private String kubeProxyVersion;
    private String kubeletVersion;
    private String machineID;
    private String operatingSystem;
    private String osImage;
    private String systemUUID;

    public NodeSystemInfoFluentImpl() {
    }

    public NodeSystemInfoFluentImpl(NodeSystemInfo instance) {
        this.withArchitecture(instance.getArchitecture()); 
        this.withBootID(instance.getBootID()); 
        this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion()); 
        this.withKernelVersion(instance.getKernelVersion()); 
        this.withKubeProxyVersion(instance.getKubeProxyVersion()); 
        this.withKubeletVersion(instance.getKubeletVersion()); 
        this.withMachineID(instance.getMachineID()); 
        this.withOperatingSystem(instance.getOperatingSystem()); 
        this.withOsImage(instance.getOsImage()); 
        this.withSystemUUID(instance.getSystemUUID()); 
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public A withArchitecture(String architecture) {
        this.architecture=architecture; return (A) this;
    }

    public Boolean hasArchitecture() {
        return this.architecture != null;
    }

    public A withNewArchitecture(StringBuilder arg1) {
        return (A)withArchitecture(new String(arg1));
    }

    public A withNewArchitecture(int[] arg1,int arg2,int arg3) {
        return (A)withArchitecture(new String(arg1, arg2, arg3));
    }

    public A withNewArchitecture(char[] arg1) {
        return (A)withArchitecture(new String(arg1));
    }

    public A withNewArchitecture(StringBuffer arg1) {
        return (A)withArchitecture(new String(arg1));
    }

    public A withNewArchitecture(byte[] arg1,int arg2) {
        return (A)withArchitecture(new String(arg1, arg2));
    }

    public A withNewArchitecture(byte[] arg1) {
        return (A)withArchitecture(new String(arg1));
    }

    public A withNewArchitecture(char[] arg1,int arg2,int arg3) {
        return (A)withArchitecture(new String(arg1, arg2, arg3));
    }

    public A withNewArchitecture(byte[] arg1,int arg2,int arg3) {
        return (A)withArchitecture(new String(arg1, arg2, arg3));
    }

    public A withNewArchitecture(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withArchitecture(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewArchitecture(String arg1) {
        return (A)withArchitecture(new String(arg1));
    }

    public String getBootID() {
        return this.bootID;
    }

    public A withBootID(String bootID) {
        this.bootID=bootID; return (A) this;
    }

    public Boolean hasBootID() {
        return this.bootID != null;
    }

    public A withNewBootID(StringBuilder arg1) {
        return (A)withBootID(new String(arg1));
    }

    public A withNewBootID(int[] arg1,int arg2,int arg3) {
        return (A)withBootID(new String(arg1, arg2, arg3));
    }

    public A withNewBootID(char[] arg1) {
        return (A)withBootID(new String(arg1));
    }

    public A withNewBootID(StringBuffer arg1) {
        return (A)withBootID(new String(arg1));
    }

    public A withNewBootID(byte[] arg1,int arg2) {
        return (A)withBootID(new String(arg1, arg2));
    }

    public A withNewBootID(byte[] arg1) {
        return (A)withBootID(new String(arg1));
    }

    public A withNewBootID(char[] arg1,int arg2,int arg3) {
        return (A)withBootID(new String(arg1, arg2, arg3));
    }

    public A withNewBootID(byte[] arg1,int arg2,int arg3) {
        return (A)withBootID(new String(arg1, arg2, arg3));
    }

    public A withNewBootID(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBootID(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBootID(String arg1) {
        return (A)withBootID(new String(arg1));
    }

    public String getContainerRuntimeVersion() {
        return this.containerRuntimeVersion;
    }

    public A withContainerRuntimeVersion(String containerRuntimeVersion) {
        this.containerRuntimeVersion=containerRuntimeVersion; return (A) this;
    }

    public Boolean hasContainerRuntimeVersion() {
        return this.containerRuntimeVersion != null;
    }

    public A withNewContainerRuntimeVersion(StringBuilder arg1) {
        return (A)withContainerRuntimeVersion(new String(arg1));
    }

    public A withNewContainerRuntimeVersion(int[] arg1,int arg2,int arg3) {
        return (A)withContainerRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewContainerRuntimeVersion(char[] arg1) {
        return (A)withContainerRuntimeVersion(new String(arg1));
    }

    public A withNewContainerRuntimeVersion(StringBuffer arg1) {
        return (A)withContainerRuntimeVersion(new String(arg1));
    }

    public A withNewContainerRuntimeVersion(byte[] arg1,int arg2) {
        return (A)withContainerRuntimeVersion(new String(arg1, arg2));
    }

    public A withNewContainerRuntimeVersion(byte[] arg1) {
        return (A)withContainerRuntimeVersion(new String(arg1));
    }

    public A withNewContainerRuntimeVersion(char[] arg1,int arg2,int arg3) {
        return (A)withContainerRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewContainerRuntimeVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withContainerRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewContainerRuntimeVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withContainerRuntimeVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewContainerRuntimeVersion(String arg1) {
        return (A)withContainerRuntimeVersion(new String(arg1));
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public A withKernelVersion(String kernelVersion) {
        this.kernelVersion=kernelVersion; return (A) this;
    }

    public Boolean hasKernelVersion() {
        return this.kernelVersion != null;
    }

    public A withNewKernelVersion(StringBuilder arg1) {
        return (A)withKernelVersion(new String(arg1));
    }

    public A withNewKernelVersion(int[] arg1,int arg2,int arg3) {
        return (A)withKernelVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKernelVersion(char[] arg1) {
        return (A)withKernelVersion(new String(arg1));
    }

    public A withNewKernelVersion(StringBuffer arg1) {
        return (A)withKernelVersion(new String(arg1));
    }

    public A withNewKernelVersion(byte[] arg1,int arg2) {
        return (A)withKernelVersion(new String(arg1, arg2));
    }

    public A withNewKernelVersion(byte[] arg1) {
        return (A)withKernelVersion(new String(arg1));
    }

    public A withNewKernelVersion(char[] arg1,int arg2,int arg3) {
        return (A)withKernelVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKernelVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withKernelVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKernelVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKernelVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKernelVersion(String arg1) {
        return (A)withKernelVersion(new String(arg1));
    }

    public String getKubeProxyVersion() {
        return this.kubeProxyVersion;
    }

    public A withKubeProxyVersion(String kubeProxyVersion) {
        this.kubeProxyVersion=kubeProxyVersion; return (A) this;
    }

    public Boolean hasKubeProxyVersion() {
        return this.kubeProxyVersion != null;
    }

    public A withNewKubeProxyVersion(StringBuilder arg1) {
        return (A)withKubeProxyVersion(new String(arg1));
    }

    public A withNewKubeProxyVersion(int[] arg1,int arg2,int arg3) {
        return (A)withKubeProxyVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKubeProxyVersion(char[] arg1) {
        return (A)withKubeProxyVersion(new String(arg1));
    }

    public A withNewKubeProxyVersion(StringBuffer arg1) {
        return (A)withKubeProxyVersion(new String(arg1));
    }

    public A withNewKubeProxyVersion(byte[] arg1,int arg2) {
        return (A)withKubeProxyVersion(new String(arg1, arg2));
    }

    public A withNewKubeProxyVersion(byte[] arg1) {
        return (A)withKubeProxyVersion(new String(arg1));
    }

    public A withNewKubeProxyVersion(char[] arg1,int arg2,int arg3) {
        return (A)withKubeProxyVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKubeProxyVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withKubeProxyVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKubeProxyVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKubeProxyVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKubeProxyVersion(String arg1) {
        return (A)withKubeProxyVersion(new String(arg1));
    }

    public String getKubeletVersion() {
        return this.kubeletVersion;
    }

    public A withKubeletVersion(String kubeletVersion) {
        this.kubeletVersion=kubeletVersion; return (A) this;
    }

    public Boolean hasKubeletVersion() {
        return this.kubeletVersion != null;
    }

    public A withNewKubeletVersion(StringBuilder arg1) {
        return (A)withKubeletVersion(new String(arg1));
    }

    public A withNewKubeletVersion(int[] arg1,int arg2,int arg3) {
        return (A)withKubeletVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKubeletVersion(char[] arg1) {
        return (A)withKubeletVersion(new String(arg1));
    }

    public A withNewKubeletVersion(StringBuffer arg1) {
        return (A)withKubeletVersion(new String(arg1));
    }

    public A withNewKubeletVersion(byte[] arg1,int arg2) {
        return (A)withKubeletVersion(new String(arg1, arg2));
    }

    public A withNewKubeletVersion(byte[] arg1) {
        return (A)withKubeletVersion(new String(arg1));
    }

    public A withNewKubeletVersion(char[] arg1,int arg2,int arg3) {
        return (A)withKubeletVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKubeletVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withKubeletVersion(new String(arg1, arg2, arg3));
    }

    public A withNewKubeletVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKubeletVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKubeletVersion(String arg1) {
        return (A)withKubeletVersion(new String(arg1));
    }

    public String getMachineID() {
        return this.machineID;
    }

    public A withMachineID(String machineID) {
        this.machineID=machineID; return (A) this;
    }

    public Boolean hasMachineID() {
        return this.machineID != null;
    }

    public A withNewMachineID(StringBuilder arg1) {
        return (A)withMachineID(new String(arg1));
    }

    public A withNewMachineID(int[] arg1,int arg2,int arg3) {
        return (A)withMachineID(new String(arg1, arg2, arg3));
    }

    public A withNewMachineID(char[] arg1) {
        return (A)withMachineID(new String(arg1));
    }

    public A withNewMachineID(StringBuffer arg1) {
        return (A)withMachineID(new String(arg1));
    }

    public A withNewMachineID(byte[] arg1,int arg2) {
        return (A)withMachineID(new String(arg1, arg2));
    }

    public A withNewMachineID(byte[] arg1) {
        return (A)withMachineID(new String(arg1));
    }

    public A withNewMachineID(char[] arg1,int arg2,int arg3) {
        return (A)withMachineID(new String(arg1, arg2, arg3));
    }

    public A withNewMachineID(byte[] arg1,int arg2,int arg3) {
        return (A)withMachineID(new String(arg1, arg2, arg3));
    }

    public A withNewMachineID(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMachineID(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMachineID(String arg1) {
        return (A)withMachineID(new String(arg1));
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public A withOperatingSystem(String operatingSystem) {
        this.operatingSystem=operatingSystem; return (A) this;
    }

    public Boolean hasOperatingSystem() {
        return this.operatingSystem != null;
    }

    public A withNewOperatingSystem(StringBuilder arg1) {
        return (A)withOperatingSystem(new String(arg1));
    }

    public A withNewOperatingSystem(int[] arg1,int arg2,int arg3) {
        return (A)withOperatingSystem(new String(arg1, arg2, arg3));
    }

    public A withNewOperatingSystem(char[] arg1) {
        return (A)withOperatingSystem(new String(arg1));
    }

    public A withNewOperatingSystem(StringBuffer arg1) {
        return (A)withOperatingSystem(new String(arg1));
    }

    public A withNewOperatingSystem(byte[] arg1,int arg2) {
        return (A)withOperatingSystem(new String(arg1, arg2));
    }

    public A withNewOperatingSystem(byte[] arg1) {
        return (A)withOperatingSystem(new String(arg1));
    }

    public A withNewOperatingSystem(char[] arg1,int arg2,int arg3) {
        return (A)withOperatingSystem(new String(arg1, arg2, arg3));
    }

    public A withNewOperatingSystem(byte[] arg1,int arg2,int arg3) {
        return (A)withOperatingSystem(new String(arg1, arg2, arg3));
    }

    public A withNewOperatingSystem(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withOperatingSystem(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewOperatingSystem(String arg1) {
        return (A)withOperatingSystem(new String(arg1));
    }

    public String getOsImage() {
        return this.osImage;
    }

    public A withOsImage(String osImage) {
        this.osImage=osImage; return (A) this;
    }

    public Boolean hasOsImage() {
        return this.osImage != null;
    }

    public A withNewOsImage(StringBuilder arg1) {
        return (A)withOsImage(new String(arg1));
    }

    public A withNewOsImage(int[] arg1,int arg2,int arg3) {
        return (A)withOsImage(new String(arg1, arg2, arg3));
    }

    public A withNewOsImage(char[] arg1) {
        return (A)withOsImage(new String(arg1));
    }

    public A withNewOsImage(StringBuffer arg1) {
        return (A)withOsImage(new String(arg1));
    }

    public A withNewOsImage(byte[] arg1,int arg2) {
        return (A)withOsImage(new String(arg1, arg2));
    }

    public A withNewOsImage(byte[] arg1) {
        return (A)withOsImage(new String(arg1));
    }

    public A withNewOsImage(char[] arg1,int arg2,int arg3) {
        return (A)withOsImage(new String(arg1, arg2, arg3));
    }

    public A withNewOsImage(byte[] arg1,int arg2,int arg3) {
        return (A)withOsImage(new String(arg1, arg2, arg3));
    }

    public A withNewOsImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withOsImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewOsImage(String arg1) {
        return (A)withOsImage(new String(arg1));
    }

    public String getSystemUUID() {
        return this.systemUUID;
    }

    public A withSystemUUID(String systemUUID) {
        this.systemUUID=systemUUID; return (A) this;
    }

    public Boolean hasSystemUUID() {
        return this.systemUUID != null;
    }

    public A withNewSystemUUID(StringBuilder arg1) {
        return (A)withSystemUUID(new String(arg1));
    }

    public A withNewSystemUUID(int[] arg1,int arg2,int arg3) {
        return (A)withSystemUUID(new String(arg1, arg2, arg3));
    }

    public A withNewSystemUUID(char[] arg1) {
        return (A)withSystemUUID(new String(arg1));
    }

    public A withNewSystemUUID(StringBuffer arg1) {
        return (A)withSystemUUID(new String(arg1));
    }

    public A withNewSystemUUID(byte[] arg1,int arg2) {
        return (A)withSystemUUID(new String(arg1, arg2));
    }

    public A withNewSystemUUID(byte[] arg1) {
        return (A)withSystemUUID(new String(arg1));
    }

    public A withNewSystemUUID(char[] arg1,int arg2,int arg3) {
        return (A)withSystemUUID(new String(arg1, arg2, arg3));
    }

    public A withNewSystemUUID(byte[] arg1,int arg2,int arg3) {
        return (A)withSystemUUID(new String(arg1, arg2, arg3));
    }

    public A withNewSystemUUID(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSystemUUID(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSystemUUID(String arg1) {
        return (A)withSystemUUID(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NodeSystemInfoFluentImpl that = (NodeSystemInfoFluentImpl) o;
        if (architecture != null ? !architecture.equals(that.architecture) :that.architecture != null) return false;
        if (bootID != null ? !bootID.equals(that.bootID) :that.bootID != null) return false;
        if (containerRuntimeVersion != null ? !containerRuntimeVersion.equals(that.containerRuntimeVersion) :that.containerRuntimeVersion != null) return false;
        if (kernelVersion != null ? !kernelVersion.equals(that.kernelVersion) :that.kernelVersion != null) return false;
        if (kubeProxyVersion != null ? !kubeProxyVersion.equals(that.kubeProxyVersion) :that.kubeProxyVersion != null) return false;
        if (kubeletVersion != null ? !kubeletVersion.equals(that.kubeletVersion) :that.kubeletVersion != null) return false;
        if (machineID != null ? !machineID.equals(that.machineID) :that.machineID != null) return false;
        if (operatingSystem != null ? !operatingSystem.equals(that.operatingSystem) :that.operatingSystem != null) return false;
        if (osImage != null ? !osImage.equals(that.osImage) :that.osImage != null) return false;
        if (systemUUID != null ? !systemUUID.equals(that.systemUUID) :that.systemUUID != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(architecture,  bootID,  containerRuntimeVersion,  kernelVersion,  kubeProxyVersion,  kubeletVersion,  machineID,  operatingSystem,  osImage,  systemUUID,  super.hashCode());
    }

}
