package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class HandlerFluentImpl<A extends HandlerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HandlerFluent<A> {

    private ExecActionBuilder exec;
    private HTTPGetActionBuilder httpGet;
    private TCPSocketActionBuilder tcpSocket;

    public HandlerFluentImpl() {
    }

    public HandlerFluentImpl(Handler instance) {
        this.withExec(instance.getExec()); 
        this.withHttpGet(instance.getHttpGet()); 
        this.withTcpSocket(instance.getTcpSocket()); 
    }

    
/**
 * This method has been deprecated, please use method buildExec instead.
 * @return The buildable object.
 */
@Deprecated public ExecAction getExec() {
        return this.exec!=null?this.exec.build():null;
    }

    public ExecAction buildExec() {
        return this.exec!=null?this.exec.build():null;
    }

    public A withExec(ExecAction exec) {
        _visitables.get("exec").remove(this.exec);
        if (exec!=null){ this.exec= new ExecActionBuilder(exec); _visitables.get("exec").add(this.exec);} return (A) this;
    }

    public Boolean hasExec() {
        return this.exec != null;
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.ExecNested<A> withNewExec() {
        return new ExecNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.ExecNested<A> withNewExecLike(ExecAction item) {
        return new ExecNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.ExecNested<A> editExec() {
        return withNewExecLike(getExec());
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.ExecNested<A> editOrNewExec() {
        return withNewExecLike(getExec() != null ? getExec(): new ExecActionBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.ExecNested<A> editOrNewExecLike(ExecAction item) {
        return withNewExecLike(getExec() != null ? getExec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHttpGet instead.
 * @return The buildable object.
 */
@Deprecated public HTTPGetAction getHttpGet() {
        return this.httpGet!=null?this.httpGet.build():null;
    }

    public HTTPGetAction buildHttpGet() {
        return this.httpGet!=null?this.httpGet.build():null;
    }

    public A withHttpGet(HTTPGetAction httpGet) {
        _visitables.get("httpGet").remove(this.httpGet);
        if (httpGet!=null){ this.httpGet= new HTTPGetActionBuilder(httpGet); _visitables.get("httpGet").add(this.httpGet);} return (A) this;
    }

    public Boolean hasHttpGet() {
        return this.httpGet != null;
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.HttpGetNested<A> withNewHttpGet() {
        return new HttpGetNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.HttpGetNested<A> withNewHttpGetLike(HTTPGetAction item) {
        return new HttpGetNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.HttpGetNested<A> editHttpGet() {
        return withNewHttpGetLike(getHttpGet());
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.HttpGetNested<A> editOrNewHttpGet() {
        return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): new HTTPGetActionBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.HttpGetNested<A> editOrNewHttpGetLike(HTTPGetAction item) {
        return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTcpSocket instead.
 * @return The buildable object.
 */
@Deprecated public TCPSocketAction getTcpSocket() {
        return this.tcpSocket!=null?this.tcpSocket.build():null;
    }

    public TCPSocketAction buildTcpSocket() {
        return this.tcpSocket!=null?this.tcpSocket.build():null;
    }

    public A withTcpSocket(TCPSocketAction tcpSocket) {
        _visitables.get("tcpSocket").remove(this.tcpSocket);
        if (tcpSocket!=null){ this.tcpSocket= new TCPSocketActionBuilder(tcpSocket); _visitables.get("tcpSocket").add(this.tcpSocket);} return (A) this;
    }

    public Boolean hasTcpSocket() {
        return this.tcpSocket != null;
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.TcpSocketNested<A> withNewTcpSocket() {
        return new TcpSocketNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.TcpSocketNested<A> withNewTcpSocketLike(TCPSocketAction item) {
        return new TcpSocketNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.TcpSocketNested<A> editTcpSocket() {
        return withNewTcpSocketLike(getTcpSocket());
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.TcpSocketNested<A> editOrNewTcpSocket() {
        return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): new TCPSocketActionBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.HandlerFluent.TcpSocketNested<A> editOrNewTcpSocketLike(TCPSocketAction item) {
        return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HandlerFluentImpl that = (HandlerFluentImpl) o;
        if (exec != null ? !exec.equals(that.exec) :that.exec != null) return false;
        if (httpGet != null ? !httpGet.equals(that.httpGet) :that.httpGet != null) return false;
        if (tcpSocket != null ? !tcpSocket.equals(that.tcpSocket) :that.tcpSocket != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(exec,  httpGet,  tcpSocket,  super.hashCode());
    }

    public class ExecNestedImpl<N> extends ExecActionFluentImpl<io.fabric8.kubernetes.api.model.HandlerFluent.ExecNested<N>> implements io.fabric8.kubernetes.api.model.HandlerFluent.ExecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExecActionBuilder builder;

            ExecNestedImpl(ExecAction item) {
                this.builder = new ExecActionBuilder(this, item);
                        
            }

            ExecNestedImpl() {
                this.builder = new ExecActionBuilder(this);
                        
            }

            public N and() {
                return (N) HandlerFluentImpl.this.withExec(builder.build());
            }

            public N endExec() {
                return and();
            }
    }


    public class HttpGetNestedImpl<N> extends HTTPGetActionFluentImpl<io.fabric8.kubernetes.api.model.HandlerFluent.HttpGetNested<N>> implements io.fabric8.kubernetes.api.model.HandlerFluent.HttpGetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HTTPGetActionBuilder builder;

            HttpGetNestedImpl(HTTPGetAction item) {
                this.builder = new HTTPGetActionBuilder(this, item);
                        
            }

            HttpGetNestedImpl() {
                this.builder = new HTTPGetActionBuilder(this);
                        
            }

            public N and() {
                return (N) HandlerFluentImpl.this.withHttpGet(builder.build());
            }

            public N endHttpGet() {
                return and();
            }
    }


    public class TcpSocketNestedImpl<N> extends TCPSocketActionFluentImpl<io.fabric8.kubernetes.api.model.HandlerFluent.TcpSocketNested<N>> implements io.fabric8.kubernetes.api.model.HandlerFluent.TcpSocketNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TCPSocketActionBuilder builder;

            TcpSocketNestedImpl(TCPSocketAction item) {
                this.builder = new TCPSocketActionBuilder(this, item);
                        
            }

            TcpSocketNestedImpl() {
                this.builder = new TCPSocketActionBuilder(this);
                        
            }

            public N and() {
                return (N) HandlerFluentImpl.this.withTcpSocket(builder.build());
            }

            public N endTcpSocket() {
                return and();
            }
    }


}
