package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ReplicaSetListFluent<A extends ReplicaSetListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,ReplicaSet item);
  public A setToItems(Integer index,ReplicaSet item);
  public A addToItems(io.fabric8.kubernetes.api.model.apps.ReplicaSet... items);
  public A addAllToItems(Collection<ReplicaSet> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.apps.ReplicaSet... items);
  public A removeAllFromItems(Collection<ReplicaSet> items);
  public A removeMatchingFromItems(Predicate<ReplicaSetBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ReplicaSet> getItems();
  public List<ReplicaSet> buildItems();
  public ReplicaSet buildItem(Integer index);
  public ReplicaSet buildFirstItem();
  public ReplicaSet buildLastItem();
  public ReplicaSet buildMatchingItem(Predicate<ReplicaSetBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ReplicaSetBuilder> predicate);
  public A withItems(List<ReplicaSet> items);
  public A withItems(io.fabric8.kubernetes.api.model.apps.ReplicaSet... items);
  public Boolean hasItems();
  public ReplicaSetListFluent.ItemsNested<A> addNewItem();
  public ReplicaSetListFluent.ItemsNested<A> addNewItemLike(ReplicaSet item);
  public ReplicaSetListFluent.ItemsNested<A> setNewItemLike(Integer index,ReplicaSet item);
  public ReplicaSetListFluent.ItemsNested<A> editItem(Integer index);
  public ReplicaSetListFluent.ItemsNested<A> editFirstItem();
  public ReplicaSetListFluent.ItemsNested<A> editLastItem();
  public ReplicaSetListFluent.ItemsNested<A> editMatchingItem(Predicate<ReplicaSetBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ReplicaSetFluent<ReplicaSetListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}