/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.junit.jupiter;

import io.fabric8.junit.jupiter.HasKubernetesClient;
import io.fabric8.junit.jupiter.api.KubernetesTest;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class NamespaceExtension
implements HasKubernetesClient,
BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback {
    public void beforeAll(ExtensionContext context) throws Exception {
        KubernetesClient client = new KubernetesClientBuilder().build();
        this.getStore(context).put(KubernetesClient.class, (Object)client);
        if (this.shouldCreateNamespace(context)) {
            this.getStore(context).put(Namespace.class, (Object)NamespaceExtension.initNamespace(client));
            this.getStore(context).put(KubernetesClient.class, (Object)((NamespacedKubernetesClient)client.adapt(NamespacedKubernetesClient.class)).inNamespace(this.getKubernetesNamespace(context).getMetadata().getName()));
        }
        for (Field field : this.extractFields(context, Namespace.class, f -> Modifier.isStatic(f.getModifiers()))) {
            this.setFieldValue(field, null, this.getKubernetesNamespace(context));
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        for (Field field : this.extractFields(context, Namespace.class, f -> !Modifier.isStatic(f.getModifiers()))) {
            this.setFieldValue(field, context.getRequiredTestInstance(), this.getKubernetesNamespace(context));
        }
    }

    public void afterAll(ExtensionContext context) {
        KubernetesClient client = this.getClient(context);
        if (this.shouldCreateNamespace(context)) {
            ((PropagationPolicyConfigurable)client.resource((HasMetadata)this.getKubernetesNamespace(context)).withGracePeriod(0L)).delete();
        }
        client.close();
    }

    private static Namespace initNamespace(KubernetesClient client) {
        Namespace namespace = (Namespace)client.resource((HasMetadata)((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(UUID.randomUUID().toString())).addToLabels("app", "fabric8-kubernetes-client-test")).endMetadata()).build()).create();
        int major = Integer.parseInt(client.getKubernetesVersion().getMajor().replaceAll("\\D+", ""));
        int minor = Integer.parseInt(client.getKubernetesVersion().getMinor().replaceAll("\\D+", ""));
        if (major < 1 || major == 1 && minor < 24) {
            List secrets = ((ServiceAccount)((ServiceAccountResource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(namespace.getMetadata().getName())).withName("default")).waitUntilCondition(sa -> sa != null && sa.getSecrets() != null && sa.getSecrets().stream().anyMatch(s -> s.getName().matches("default-token.+")), 5L, TimeUnit.SECONDS)).getSecrets();
            for (ObjectReference secret : secrets) {
                ((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace.getMetadata().getName())).withName(secret.getName())).waitUntilCondition(Objects::nonNull, 5L, TimeUnit.SECONDS);
            }
        }
        return namespace;
    }

    private boolean shouldCreateNamespace(ExtensionContext context) {
        KubernetesTest annotation = this.findAnnotation(context.getRequiredTestClass(), KubernetesTest.class);
        return annotation == null || annotation.createEphemeralNamespace();
    }

    private Namespace getKubernetesNamespace(ExtensionContext context) {
        Namespace namespace = (Namespace)this.getStore(context).get(Namespace.class, Namespace.class);
        if (namespace == null) {
            throw new IllegalStateException("No Kubernetes Namespace found");
        }
        return namespace;
    }
}

