/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;

public class LeaderElectionRecord {
    private final String holderIdentity;
    private final Duration leaseDuration;
    @JsonFormat(timezone="UTC", pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
    private final ZonedDateTime acquireTime;
    @JsonFormat(timezone="UTC", pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
    private final ZonedDateTime renewTime;
    private final int leaderTransitions;

    @JsonCreator
    public LeaderElectionRecord(@JsonProperty(value="holderIdentity") String holderIdentity, @JsonProperty(value="leaseDuration") Duration leaseDuration, @JsonProperty(value="acquireTime") ZonedDateTime acquireTime, @JsonProperty(value="renewTime") ZonedDateTime renewTime, @JsonProperty(value="leaderTransitions") int leaderTransitions) {
        this.holderIdentity = holderIdentity;
        this.leaseDuration = Objects.requireNonNull(leaseDuration, "leaseDuration is required");
        this.acquireTime = Objects.requireNonNull(acquireTime, "acquireTime is required");
        this.renewTime = Objects.requireNonNull(renewTime, "renewTime is required");
        this.leaderTransitions = leaderTransitions;
    }

    public String getHolderIdentity() {
        return this.holderIdentity;
    }

    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public ZonedDateTime getAcquireTime() {
        return this.acquireTime;
    }

    public ZonedDateTime getRenewTime() {
        return this.renewTime;
    }

    public int getLeaderTransitions() {
        return this.leaderTransitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaderElectionRecord that = (LeaderElectionRecord)o;
        return this.leaderTransitions == that.leaderTransitions && Objects.equals(this.holderIdentity, that.holderIdentity) && Objects.equals(this.leaseDuration, that.leaseDuration) && Objects.equals(this.acquireTime, that.acquireTime) && Objects.equals(this.renewTime, that.renewTime);
    }

    public int hashCode() {
        return Objects.hash(this.holderIdentity, this.leaseDuration, this.acquireTime, this.renewTime, this.leaderTransitions);
    }

    public static LeaderElectionRecordBuilder builder() {
        return new LeaderElectionRecordBuilder();
    }

    public LeaderElectionRecordBuilder toBuilder() {
        return new LeaderElectionRecordBuilder().holderIdentity(this.holderIdentity).leaseDuration(this.leaseDuration).acquireTime(this.acquireTime).renewTime(this.renewTime).leaderTransitions(this.leaderTransitions);
    }

    public static class LeaderElectionRecordBuilder {
        private String holderIdentity;
        private Duration leaseDuration;
        private ZonedDateTime acquireTime;
        private ZonedDateTime renewTime;
        private int leaderTransitions;

        LeaderElectionRecordBuilder() {
        }

        public LeaderElectionRecordBuilder holderIdentity(String holderIdentity) {
            this.holderIdentity = holderIdentity;
            return this;
        }

        public LeaderElectionRecordBuilder leaseDuration(Duration leaseDuration) {
            this.leaseDuration = leaseDuration;
            return this;
        }

        @JsonFormat(timezone="UTC", pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        public LeaderElectionRecordBuilder acquireTime(ZonedDateTime acquireTime) {
            this.acquireTime = acquireTime;
            return this;
        }

        @JsonFormat(timezone="UTC", pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
        public LeaderElectionRecordBuilder renewTime(ZonedDateTime renewTime) {
            this.renewTime = renewTime;
            return this;
        }

        public LeaderElectionRecordBuilder leaderTransitions(int leaderTransitions) {
            this.leaderTransitions = leaderTransitions;
            return this;
        }

        public LeaderElectionRecord build() {
            return new LeaderElectionRecord(this.holderIdentity, this.leaseDuration, this.acquireTime, this.renewTime, this.leaderTransitions);
        }

        public String toString() {
            return "LeaderElectionRecord.LeaderElectionRecordBuilder(holderIdentity=" + this.holderIdentity + ", leaseDuration=" + this.leaseDuration + ", acquireTime=" + this.acquireTime + ", renewTime=" + this.renewTime + ", leaderTransitions=" + this.leaderTransitions + ")";
        }
    }
}

