/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IPBlock;
import io.fabric8.kubernetes.api.model.networking.v1.IPBlockFluent;

public class IPBlockBuilder
extends IPBlockFluent<IPBlockBuilder>
implements VisitableBuilder<IPBlock, IPBlockBuilder> {
    IPBlockFluent<?> fluent;
    Boolean validationEnabled;

    public IPBlockBuilder() {
        this(false);
    }

    public IPBlockBuilder(Boolean validationEnabled) {
        this(new IPBlock(), validationEnabled);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IPBlock(), validationEnabled);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, IPBlock instance) {
        this(fluent, instance, false);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, IPBlock instance, Boolean validationEnabled) {
        this.fluent = fluent;
        IPBlock iPBlock = instance = instance != null ? instance : new IPBlock();
        if (instance != null) {
            fluent.withCidr(instance.getCidr());
            fluent.withExcept(instance.getExcept());
            fluent.withCidr(instance.getCidr());
            fluent.withExcept(instance.getExcept());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public IPBlockBuilder(IPBlock instance) {
        this(instance, (Boolean)false);
    }

    public IPBlockBuilder(IPBlock instance, Boolean validationEnabled) {
        this.fluent = this;
        IPBlock iPBlock = instance = instance != null ? instance : new IPBlock();
        if (instance != null) {
            this.withCidr(instance.getCidr());
            this.withExcept(instance.getExcept());
            this.withCidr(instance.getCidr());
            this.withExcept(instance.getExcept());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IPBlock build() {
        IPBlock buildable = new IPBlock(this.fluent.getCidr(), this.fluent.getExcept());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

