/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Constants;
import io.ebean.querybean.generator.FindDbName;
import io.ebean.querybean.generator.ModuleMeta;
import io.ebean.querybean.generator.PropertyType;
import io.ebean.querybean.generator.PropertyTypeArray;
import io.ebean.querybean.generator.PropertyTypeAssoc;
import io.ebean.querybean.generator.PropertyTypeEnum;
import io.ebean.querybean.generator.PropertyTypeMap;
import io.ebean.querybean.generator.PropertyTypeScalar;
import io.ebean.querybean.generator.PropertyTypeScalarComparable;
import io.ebean.querybean.generator.ReadModuleInfo;
import io.ebean.querybean.generator.Split;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class ProcessingContext
implements Constants {
    private final ProcessingEnvironment processingEnv;
    private final Types typeUtils;
    private final Filer filer;
    private final Messager messager;
    private final Elements elementUtils;
    private final PropertyTypeMap propertyTypeMap = new PropertyTypeMap();
    private final ReadModuleInfo readModuleInfo;
    private final Set<String> allEntityPackages = new TreeSet<String>();
    private final Set<String> otherClasses = new TreeSet<String>();
    private final Set<String> prefixEntities = new TreeSet<String>();
    private final Set<String> dbEntities = new TreeSet<String>();
    private final Map<String, Set<String>> otherDbEntities = new TreeMap<String, Set<String>>();
    private final Set<String> loaded = new HashSet<String>();
    private List<String> loadedPrefixEntities = new ArrayList<String>();
    private String factoryPackage;

    ProcessingContext(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.readModuleInfo = new ReadModuleInfo(this);
    }

    TypeElement entityAnnotation() {
        return this.elementUtils.getTypeElement("javax.persistence.Entity");
    }

    TypeElement embeddableAnnotation() {
        return this.elementUtils.getTypeElement("javax.persistence.Embeddable");
    }

    TypeElement converterAnnotation() {
        return this.elementUtils.getTypeElement("javax.persistence.Converter");
    }

    TypeElement componentAnnotation() {
        return this.elementUtils.getTypeElement("io.ebean.annotation.EbeanComponent");
    }

    List<VariableElement> allFields(Element element) {
        ArrayList<VariableElement> list = new ArrayList<VariableElement>();
        this.gatherProperties(list, element);
        return list;
    }

    private void gatherProperties(List<VariableElement> fields, Element element) {
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superclass = typeElement.getSuperclass();
        Element mappedSuper = this.typeUtils.asElement(superclass);
        if (this.isMappedSuperOrInheritance(mappedSuper)) {
            this.gatherProperties(fields, mappedSuper);
        }
        List<VariableElement> allFields = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (VariableElement field : allFields) {
            if (this.ignoreField(field)) continue;
            fields.add(field);
        }
    }

    private boolean ignoreField(VariableElement field) {
        return this.isStaticOrTransient(field) || this.ignoreEbeanInternalFields(field);
    }

    private boolean ignoreEbeanInternalFields(VariableElement field) {
        String fieldName = field.getSimpleName().toString();
        return fieldName.startsWith("_ebean") || fieldName.startsWith("_EBEAN");
    }

    private boolean isStaticOrTransient(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        return modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT) || ProcessingContext.hasAnnotations(field, "javax.persistence.Transient");
    }

    private static boolean hasAnnotations(Element element, String ... annotations) {
        return ProcessingContext.getAnnotation(element, annotations) != null;
    }

    private static AnnotationMirror getAnnotation(Element element, String ... annotations) {
        if (element == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String name = annotationMirror.getAnnotationType().asElement().toString();
            for (String annotation : annotations) {
                if (!annotation.equals(name)) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private boolean isMappedSuperOrInheritance(Element mappedSuper) {
        return ProcessingContext.hasAnnotations(mappedSuper, "javax.persistence.MappedSuperclass", "javax.persistence.Inheritance");
    }

    private boolean isEntityOrEmbedded(Element mappedSuper) {
        return ProcessingContext.hasAnnotations(mappedSuper, "javax.persistence.Entity", "javax.persistence.Embeddable");
    }

    boolean isEntity(Element element) {
        return ProcessingContext.hasAnnotations(element, "javax.persistence.Entity");
    }

    boolean isEmbeddable(Element element) {
        return ProcessingContext.hasAnnotations(element, "javax.persistence.Embeddable");
    }

    String findDbName(TypeElement element) {
        return FindDbName.value(element, this.typeUtils);
    }

    private static boolean dbJsonField(Element field) {
        return ProcessingContext.hasAnnotations(field, "io.ebean.annotation.DbJson", "io.ebean.annotation.DbJsonB");
    }

    private static boolean dbArrayField(Element field) {
        return ProcessingContext.hasAnnotations(field, "io.ebean.annotation.DbArray");
    }

    private static String typeDef(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return declaredType.asElement().toString();
        }
        return typeMirror.toString();
    }

    PropertyType getPropertyType(VariableElement field) {
        TypeElement element;
        String fullType;
        TypeMirror typeMirror;
        TypeMirror currentType = typeMirror = field.asType();
        while (currentType != null) {
            PropertyType type = this.propertyTypeMap.getType(ProcessingContext.typeDef(currentType));
            if (type != null) {
                return type;
            }
            TypeElement fieldType = (TypeElement)this.typeUtils.asElement(currentType);
            currentType = fieldType == null ? null : fieldType.getSuperclass();
        }
        if (ProcessingContext.dbJsonField(field)) {
            return this.propertyTypeMap.getDbJsonType();
        }
        if (ProcessingContext.dbArrayField(field)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            fullType = ProcessingContext.typeDef(declaredType.getTypeArguments().get(0));
            return new PropertyTypeArray(fullType, Split.shortName(fullType));
        }
        Element fieldType = this.typeUtils.asElement(typeMirror);
        if (fieldType == null) {
            return null;
        }
        if ((fieldType = this.elementUtils.getTypeElement(fieldType.toString())).getKind() == ElementKind.ENUM) {
            fullType = ProcessingContext.typeDef(typeMirror);
            return new PropertyTypeEnum(fullType, Split.shortName(fullType));
        }
        String targetEntity = this.readTargetEntity(field);
        if (targetEntity != null && this.isEntityOrEmbedded(element = this.elementUtils.getTypeElement(targetEntity))) {
            return this.createPropertyTypeAssoc(ProcessingContext.typeDef(element.asType()));
        }
        if (this.isEntityOrEmbedded(fieldType)) {
            return this.createPropertyTypeAssoc(ProcessingContext.typeDef(typeMirror));
        }
        PropertyType result = typeMirror.getKind() == TypeKind.DECLARED ? this.createManyTypeAssoc(field, (DeclaredType)typeMirror) : null;
        if (result != null) {
            return result;
        }
        if (this.typeInstanceOf(typeMirror, "java.lang.Comparable")) {
            return new PropertyTypeScalarComparable(typeMirror.toString());
        }
        return new PropertyTypeScalar(typeMirror.toString());
    }

    private boolean typeInstanceOf(TypeMirror typeMirror, CharSequence desiredInterface) {
        TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
        if (typeElement == null || typeElement.getQualifiedName().contentEquals("java.lang.Object")) {
            return false;
        }
        if (typeElement.getQualifiedName().contentEquals(desiredInterface)) {
            return true;
        }
        return this.typeInstanceOf(typeElement.getSuperclass(), desiredInterface) || typeElement.getInterfaces().stream().anyMatch(t -> this.typeInstanceOf((TypeMirror)t, desiredInterface));
    }

    private PropertyType createManyTypeAssoc(VariableElement field, DeclaredType declaredType) {
        Element argElement;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() == 1) {
            Element argElement2 = this.typeUtils.asElement(typeArguments.get(0));
            if (this.isEntityOrEmbedded(argElement2)) {
                return this.createPropertyTypeAssoc(ProcessingContext.typeDef(argElement2.asType()));
            }
        } else if (typeArguments.size() == 2 && this.isEntityOrEmbedded(argElement = this.typeUtils.asElement(typeArguments.get(1)))) {
            return this.createPropertyTypeAssoc(ProcessingContext.typeDef(argElement.asType()));
        }
        return null;
    }

    private String readTargetEntity(Element declaredType) {
        for (AnnotationMirror annotationMirror : declaredType.getAnnotationMirrors()) {
            Object targetEntity = ProcessingContext.readTargetEntityFromAnnotation(annotationMirror);
            if (targetEntity == null) continue;
            return targetEntity.toString();
        }
        return null;
    }

    private static Object readTargetEntityFromAnnotation(AnnotationMirror mirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!"targetEntity".equals(entry.getKey().getSimpleName().toString())) continue;
            return entry.getValue().getValue();
        }
        return null;
    }

    private PropertyType createPropertyTypeAssoc(String fullName) {
        String[] split = Split.split(fullName);
        String propertyName = "QAssoc" + split[1];
        String packageName = this.packageAppend(split[0]);
        return new PropertyTypeAssoc(propertyName, packageName);
    }

    private String packageAppend(String origPackage) {
        if (origPackage == null) {
            return "query.assoc";
        }
        return origPackage + ".query.assoc";
    }

    JavaFileObject createWriter(String factoryClassName, Element originatingElement) throws IOException {
        return this.filer.createSourceFile(factoryClassName, originatingElement);
    }

    JavaFileObject createWriter(String factoryClassName) throws IOException {
        return this.filer.createSourceFile(factoryClassName, new Element[0]);
    }

    void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    void logNote(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    void readModuleInfo() {
        TypeElement factoryType;
        String factory = this.loadMetaInfServices();
        if (factory != null && (factoryType = this.elementUtils.getTypeElement(factory)) != null) {
            ModuleMeta read = this.readModuleInfo.read(factoryType);
            this.loadedPrefixEntities.addAll(read.getEntities());
            this.otherClasses.addAll(read.getOther());
        }
    }

    void addEntity(String beanFullName, String dbName) {
        this.loaded.add(beanFullName);
        String pkg = this.packageOf(beanFullName);
        if (pkg != null) {
            this.allEntityPackages.add(pkg);
            this.updateFactoryPackage(pkg);
        }
        if (dbName != null) {
            this.prefixEntities.add(dbName + ":" + beanFullName);
            this.otherDbEntities.computeIfAbsent(dbName, s -> new TreeSet()).add(beanFullName);
        } else {
            this.prefixEntities.add(beanFullName);
            this.dbEntities.add(beanFullName);
        }
    }

    int complete() {
        int added = 0;
        for (String oldPrefixEntity : this.loadedPrefixEntities) {
            String entityClass;
            String[] prefixEntityClass = oldPrefixEntity.split(":");
            String dbName = null;
            if (prefixEntityClass.length > 1) {
                dbName = prefixEntityClass[0];
                entityClass = prefixEntityClass[1];
            } else {
                entityClass = prefixEntityClass[0];
            }
            if (this.loaded.contains(entityClass)) continue;
            this.addEntity(entityClass, dbName);
            ++added;
        }
        return added;
    }

    private String packageOf(String beanFullName) {
        int pos = beanFullName.lastIndexOf(46);
        if (pos > -1) {
            return beanFullName.substring(0, pos);
        }
        return null;
    }

    private void updateFactoryPackage(String pkg) {
        if (pkg != null && (this.factoryPackage == null || this.factoryPackage.length() > pkg.length())) {
            this.factoryPackage = pkg;
        }
    }

    FileObject createMetaInfServicesWriter() throws IOException {
        return this.createMetaInfWriter("META-INF/services/io.ebean.config.ModuleInfoLoader");
    }

    FileObject createManifestWriter() throws IOException {
        return this.createMetaInfWriter("META-INF/ebean-generated-info.mf");
    }

    FileObject createMetaInfWriter(String target) throws IOException {
        return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", target, new Element[0]);
    }

    public boolean hasOtherClasses() {
        return !this.otherClasses.isEmpty();
    }

    public Set<String> getOtherClasses() {
        return this.otherClasses;
    }

    void addOther(Element element) {
        this.otherClasses.add(element.toString());
    }

    Set<String> getPrefixEntities() {
        return this.prefixEntities;
    }

    Set<String> getDbEntities() {
        return this.dbEntities;
    }

    Map<String, Set<String>> getOtherDbEntities() {
        return this.otherDbEntities;
    }

    Set<String> getAllEntityPackages() {
        return this.allEntityPackages;
    }

    String getFactoryPackage() {
        return this.factoryPackage != null ? this.factoryPackage : "unknown";
    }

    String loadMetaInfServices() {
        try {
            Reader reader;
            LineNumberReader lineReader;
            String line;
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.ebean.config.ModuleInfoLoader");
            if (fileObject != null && (line = (lineReader = new LineNumberReader(reader = fileObject.openReader(true))).readLine()) != null) {
                return line.trim();
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            this.logNote(null, "FilerException reading services file: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logError(null, "Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return null;
    }
}

