/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery;

import io.ebean.CacheMode;
import io.ebean.DB;
import io.ebean.Database;
import io.ebean.DtoQuery;
import io.ebean.ExpressionList;
import io.ebean.FetchConfig;
import io.ebean.FetchGroup;
import io.ebean.FetchPath;
import io.ebean.FutureIds;
import io.ebean.FutureList;
import io.ebean.FutureRowCount;
import io.ebean.PagedList;
import io.ebean.PersistenceContextScope;
import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.RawSql;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import io.ebean.Version;
import io.ebean.search.MultiMatch;
import io.ebean.search.TextCommonTerms;
import io.ebean.search.TextQueryString;
import io.ebean.search.TextSimple;
import io.ebean.service.SpiFetchGroupQuery;
import io.ebean.text.PathProperties;
import io.ebean.typequery.TQProperty;
import io.ebeaninternal.api.SpiQueryFetch;
import io.ebeaninternal.server.util.ArrayStack;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class TQRootBean<T, R> {
    private final Query<T> query;
    private ArrayStack<ExpressionList<T>> whereStack;
    private ArrayStack<ExpressionList<T>> textStack;
    private boolean textMode;
    private R root;

    public TQRootBean(Class<T> beanType) {
        this(beanType, DB.getDefault());
    }

    public TQRootBean(Class<T> beanType, Database database) {
        this(database.find(beanType));
    }

    protected TQRootBean(Class<T> beanType, Transaction transaction) {
        this(beanType);
        this.query.usingTransaction(transaction);
    }

    protected TQRootBean(Class<T> beanType, Database database, Transaction transaction) {
        this(beanType, database);
        this.query.usingTransaction(transaction);
    }

    public TQRootBean(Query<T> query) {
        this.query = query;
        this.root = this;
    }

    public TQRootBean(boolean aliasDummy) {
        this.query = null;
    }

    public FetchGroup<T> buildFetchGroup() {
        return ((SpiFetchGroupQuery)this.query()).buildFetchGroup();
    }

    protected void setRoot(R root) {
        this.root = root;
    }

    @Nonnull
    public Query<T> query() {
        return this.query;
    }

    public R select(String properties) {
        this.query.select(properties);
        return this.root;
    }

    public R select(FetchGroup<T> fetchGroup) {
        this.query.select(fetchGroup);
        return this.root;
    }

    @SafeVarargs
    public final R select(TQProperty<R> ... properties) {
        ((SpiQueryFetch)this.query).selectProperties(this.properties(properties));
        return this.root;
    }

    private Set<String> properties(TQProperty<R>[] properties) {
        LinkedHashSet<String> props = new LinkedHashSet<String>();
        for (TQProperty<R> property : properties) {
            props.add(property.propertyName());
        }
        return props;
    }

    public R fetch(String path) {
        this.query.fetch(path);
        return this.root;
    }

    public R fetchQuery(String path) {
        this.query.fetchQuery(path);
        return this.root;
    }

    public R fetchCache(String path) {
        this.query.fetchCache(path);
        return this.root;
    }

    public R fetchQuery(String path, String properties) {
        this.query.fetchQuery(path, properties);
        return this.root;
    }

    public R fetchCache(String path, String properties) {
        this.query.fetchCache(path, properties);
        return this.root;
    }

    public R fetch(String path, String properties) {
        this.query.fetch(path, properties);
        return this.root;
    }

    public R fetch(String path, String properties, FetchConfig fetchConfig) {
        this.query.fetch(path, properties, fetchConfig);
        return this.root;
    }

    public R fetch(String path, FetchConfig fetchConfig) {
        this.query.fetch(path, fetchConfig);
        return this.root;
    }

    public R apply(PathProperties pathProperties) {
        this.query.apply((FetchPath)pathProperties);
        return this.root;
    }

    public R asOf(Timestamp asOf) {
        this.query.asOf(asOf);
        return this.root;
    }

    public R asDraft() {
        this.query.asDraft();
        return this.root;
    }

    public R setIncludeSoftDeletes() {
        this.query.setIncludeSoftDeletes();
        return this.root;
    }

    public R alias(String alias) {
        this.query.alias(alias);
        return this.root;
    }

    public R setMaxRows(int maxRows) {
        this.query.setMaxRows(maxRows);
        return this.root;
    }

    public R setFirstRow(int firstRow) {
        this.query.setFirstRow(firstRow);
        return this.root;
    }

    public R setAllowLoadErrors() {
        this.query.setAllowLoadErrors();
        return this.root;
    }

    public R setAutoTune(boolean autoTune) {
        this.query.setAutoTune(autoTune);
        return this.root;
    }

    public R setBufferFetchSizeHint(int fetchSize) {
        this.query.setBufferFetchSizeHint(fetchSize);
        return this.root;
    }

    public R setDistinct(boolean distinct) {
        this.query.setDistinct(distinct);
        return this.root;
    }

    public R setDocIndexName(String indexName) {
        this.query.setDocIndexName(indexName);
        return this.root;
    }

    public R setInheritType(Class<? extends T> type) {
        this.query.setInheritType(type);
        return this.root;
    }

    public R setBaseTable(String baseTable) {
        this.query.setBaseTable(baseTable);
        return this.root;
    }

    public R withLock(Query.LockType lockType) {
        this.query.withLock(lockType);
        return this.root;
    }

    public R withLock(Query.LockType lockType, Query.LockWait lockWait) {
        this.query.withLock(lockType, lockWait);
        return this.root;
    }

    public R forUpdate() {
        this.query.forUpdate();
        return this.root;
    }

    public R forUpdateNoWait() {
        this.query.forUpdateNoWait();
        return this.root;
    }

    public R forUpdateSkipLocked() {
        this.query.forUpdateSkipLocked();
        return this.root;
    }

    public UpdateQuery<T> asUpdate() {
        return this.query.asUpdate();
    }

    public <D> DtoQuery<D> asDto(Class<D> dtoClass) {
        return this.query.asDto(dtoClass);
    }

    public R setId(Object id) {
        this.query.setId(id);
        return this.root;
    }

    public R setIdIn(Object ... ids) {
        this.query.where().idIn(ids);
        return this.root;
    }

    public R setIdIn(Collection<?> ids) {
        this.query.where().idIn(ids);
        return this.root;
    }

    public R setLabel(String label) {
        this.query.setLabel(label);
        return this.root;
    }

    public R setProfileLocation(ProfileLocation profileLocation) {
        this.query.setProfileLocation(profileLocation);
        return this.root;
    }

    public R setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.query.setLazyLoadBatchSize(lazyLoadBatchSize);
        return this.root;
    }

    public R setLoadBeanCache(boolean loadBeanCache) {
        this.query.setLoadBeanCache(loadBeanCache);
        return this.root;
    }

    public R setMapKey(String mapKey) {
        this.query.setMapKey(mapKey);
        return this.root;
    }

    public R setPersistenceContextScope(PersistenceContextScope scope) {
        this.query.setPersistenceContextScope(scope);
        return this.root;
    }

    public R setRawSql(RawSql rawSql) {
        this.query.setRawSql(rawSql);
        return this.root;
    }

    public R setReadOnly(boolean readOnly) {
        this.query.setReadOnly(readOnly);
        return this.root;
    }

    public R setUseCache(boolean useCache) {
        this.query.setUseCache(useCache);
        return this.root;
    }

    public R setBeanCacheMode(CacheMode beanCacheMode) {
        this.query.setBeanCacheMode(beanCacheMode);
        return this.root;
    }

    public R setUseDocStore(boolean useDocStore) {
        this.query.setUseDocStore(useDocStore);
        return this.root;
    }

    public R setDisableLazyLoading(boolean disableLazyLoading) {
        this.query.setDisableLazyLoading(disableLazyLoading);
        return this.root;
    }

    public R setDisableReadAuditing() {
        this.query.setDisableReadAuditing();
        return this.root;
    }

    public R setUseQueryCache(boolean useCache) {
        this.query.setUseQueryCache(useCache);
        return this.root;
    }

    public R setUseQueryCache(CacheMode cacheMode) {
        this.query.setUseQueryCache(cacheMode);
        return this.root;
    }

    public R setTimeout(int secs) {
        this.query.setTimeout(secs);
        return this.root;
    }

    public Set<String> validate() {
        return this.query.validate();
    }

    public R raw(String rawExpression) {
        this.peekExprList().raw(rawExpression);
        return this.root;
    }

    public R raw(String rawExpression, Object ... bindValues) {
        this.peekExprList().raw(rawExpression, bindValues);
        return this.root;
    }

    public R rawOrEmpty(String raw, Collection<?> values) {
        this.peekExprList().rawOrEmpty(raw, values);
        return this.root;
    }

    public R raw(String rawExpression, Object bindValue) {
        this.peekExprList().raw(rawExpression, bindValue);
        return this.root;
    }

    public R orderBy() {
        return this.root;
    }

    public R order() {
        return this.root;
    }

    public R orderBy(String orderByClause) {
        this.query.orderBy(orderByClause);
        return this.root;
    }

    public R order(String orderByClause) {
        this.query.order(orderByClause);
        return this.root;
    }

    public R or() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().or());
        return this.root;
    }

    public R and() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().and());
        return this.root;
    }

    public R not() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().not());
        return this.root;
    }

    public R must() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().must());
        return this.root;
    }

    public R mustNot() {
        return this.pushExprList((ExpressionList<T>)this.peekExprList().mustNot());
    }

    public R should() {
        return this.pushExprList((ExpressionList<T>)this.peekExprList().should());
    }

    public R endJunction() {
        if (this.textMode) {
            this.textStack.pop();
        } else {
            this.whereStack.pop();
        }
        return this.root;
    }

    public R endOr() {
        return this.endJunction();
    }

    public R endAnd() {
        return this.endJunction();
    }

    public R endNot() {
        return this.endJunction();
    }

    private R pushExprList(ExpressionList<T> list) {
        if (this.textMode) {
            this.textStack.push(list);
        } else {
            this.whereStack.push(list);
        }
        return this.root;
    }

    public R where() {
        this.textMode = false;
        return this.root;
    }

    public R text() {
        this.textMode = true;
        return this.root;
    }

    public R multiMatch(String query, MultiMatch multiMatch) {
        this.peekExprList().multiMatch(query, multiMatch);
        return this.root;
    }

    public R multiMatch(String query, String ... properties) {
        this.peekExprList().multiMatch(query, properties);
        return this.root;
    }

    public R textCommonTerms(String query, TextCommonTerms options) {
        this.peekExprList().textCommonTerms(query, options);
        return this.root;
    }

    public R textSimple(String query, TextSimple options) {
        this.peekExprList().textSimple(query, options);
        return this.root;
    }

    public R textQueryString(String query, TextQueryString options) {
        this.peekExprList().textQueryString(query, options);
        return this.root;
    }

    public R usingTransaction(Transaction transaction) {
        this.query.usingTransaction(transaction);
        return this.root;
    }

    public R usingConnection(Connection connection) {
        this.query.usingConnection(connection);
        return this.root;
    }

    public boolean exists() {
        return this.query.exists();
    }

    @Nullable
    public T findOne() {
        return (T)this.query.findOne();
    }

    @Nonnull
    public Optional<T> findOneOrEmpty() {
        return this.query.findOneOrEmpty();
    }

    @Nonnull
    public List<T> findList() {
        return this.query.findList();
    }

    @Nonnull
    public Stream<T> findStream() {
        return this.query.findStream();
    }

    @Deprecated
    public Stream<T> findLargeStream() {
        return this.query.findLargeStream();
    }

    @Nonnull
    public Set<T> findSet() {
        return this.query.findSet();
    }

    @Nonnull
    public <A> List<A> findIds() {
        return this.query.findIds();
    }

    @Nonnull
    public <K> Map<K, T> findMap() {
        return this.query.findMap();
    }

    @Nonnull
    public QueryIterator<T> findIterate() {
        return this.query.findIterate();
    }

    @Nonnull
    public <A> List<A> findSingleAttributeList() {
        return this.query.findSingleAttributeList();
    }

    public <A> A findSingleAttribute() {
        return (A)this.query.findSingleAttribute();
    }

    public void findEach(Consumer<T> consumer) {
        this.query.findEach(consumer);
    }

    public void findEach(int batch, Consumer<List<T>> consumer) {
        this.query.findEach(batch, consumer);
    }

    public void findEachWhile(Predicate<T> consumer) {
        this.query.findEachWhile(consumer);
    }

    @Nonnull
    public List<Version<T>> findVersions() {
        return this.query.findVersions();
    }

    @Nonnull
    public List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        return this.query.findVersionsBetween(start, end);
    }

    @Nonnull
    public int findCount() {
        return this.query.findCount();
    }

    @Nonnull
    public FutureRowCount<T> findFutureCount() {
        return this.query.findFutureCount();
    }

    @Nonnull
    public FutureIds<T> findFutureIds() {
        return this.query.findFutureIds();
    }

    @Nonnull
    public FutureList<T> findFutureList() {
        return this.query.findFutureList();
    }

    @Nonnull
    public PagedList<T> findPagedList() {
        return this.query.findPagedList();
    }

    public int delete() {
        return this.query.delete();
    }

    public String getGeneratedSql() {
        return this.query.getGeneratedSql();
    }

    @Nonnull
    public Class<T> getBeanType() {
        return this.query.getBeanType();
    }

    @Nonnull
    public ExpressionList<T> getExpressionList() {
        return this.query.where();
    }

    public R having() {
        if (this.whereStack == null) {
            this.whereStack = new ArrayStack();
        }
        this.whereStack.push((Object)this.query.having());
        return this.root;
    }

    public ExpressionList<T> havingClause() {
        return this.query.having();
    }

    protected ExpressionList<T> peekExprList() {
        if (this.textMode) {
            return this._peekText();
        }
        if (this.whereStack == null) {
            this.whereStack = new ArrayStack();
            this.whereStack.push((Object)this.query.where());
        }
        return (ExpressionList)this.whereStack.peek();
    }

    protected ExpressionList<T> _peekText() {
        if (this.textStack == null) {
            this.textStack = new ArrayStack();
            this.textStack.push((Object)this.query.text());
        }
        return (ExpressionList)this.textStack.peek();
    }
}

