/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationVersion;
import javax.annotation.Nonnull;

public abstract class LocalMigrationResource
implements Comparable<LocalMigrationResource> {
    protected final MigrationVersion version;
    protected final String location;
    private String type;

    public LocalMigrationResource(MigrationVersion version, String location) {
        this.version = version;
        this.location = location;
        this.type = version.getType();
    }

    public String toString() {
        return this.version.toString();
    }

    public boolean isRepeatable() {
        return this.version.isRepeatable();
    }

    public boolean isRepeatableInit() {
        return this.version.isRepeatableInit();
    }

    public boolean isRepeatableLast() {
        return this.version.isRepeatableLast();
    }

    @Nonnull
    public String key() {
        if (this.isRepeatable()) {
            return this.version.getComment().toLowerCase();
        }
        return this.version.normalised();
    }

    @Nonnull
    public String getComment() {
        String comment = this.version.getComment();
        return comment == null || comment.isEmpty() ? "-" : comment;
    }

    @Override
    public int compareTo(LocalMigrationResource o) {
        return this.version.compareTo(o.version);
    }

    @Nonnull
    public MigrationVersion getVersion() {
        return this.version;
    }

    public String getLocation() {
        return this.location;
    }

    @Nonnull
    public abstract String getContent();

    @Nonnull
    public String getType() {
        return this.type;
    }

    public void setInitType() {
        this.type = "B";
    }
}

