/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebeaninternal.dbmigration.ddlgeneration.platform.SplitColumns;
import io.ebeaninternal.dbmigration.migration.AddUniqueConstraint;
import io.ebeaninternal.dbmigration.migration.UniqueConstraint;
import java.util.Arrays;
import java.util.Objects;

public class MCompoundUniqueConstraint {
    private final String name;
    private final boolean oneToOne;
    private final String[] columns;
    private final String platforms;
    private String[] nullableColumns;

    public MCompoundUniqueConstraint(String[] columns, String name) {
        this.name = name;
        this.columns = columns;
        this.oneToOne = true;
        this.platforms = null;
    }

    public MCompoundUniqueConstraint(String[] columns, boolean oneToOne, String name, String platforms) {
        this.name = name;
        this.columns = columns;
        this.oneToOne = oneToOne;
        this.platforms = platforms;
    }

    public MCompoundUniqueConstraint(AddUniqueConstraint change) {
        this.name = change.getConstraintName();
        this.columns = SplitColumns.split(change.getColumnNames());
        this.oneToOne = Boolean.TRUE.equals(change.isOneToOne());
        this.platforms = change.getPlatforms();
        this.nullableColumns = SplitColumns.splitWithNull(change.getNullableColumns());
    }

    public MCompoundUniqueConstraint(UniqueConstraint uq) {
        this.name = uq.getName();
        this.columns = SplitColumns.split(uq.getColumnNames());
        this.oneToOne = Boolean.TRUE.equals(uq.isOneToOne());
        this.platforms = uq.getPlatforms();
        this.nullableColumns = SplitColumns.splitWithNull(uq.getNullableColumns());
    }

    public String[] getColumns() {
        return this.columns;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public String getName() {
        return this.name;
    }

    public String getPlatforms() {
        return this.platforms;
    }

    public UniqueConstraint getUniqueConstraint() {
        UniqueConstraint uq = new UniqueConstraint();
        uq.setName(this.getName());
        uq.setColumnNames(this.join(this.columns));
        uq.setNullableColumns(this.join(this.nullableColumns));
        uq.setOneToOne(this.isOneToOne());
        uq.setPlatforms(this.platforms);
        return uq;
    }

    public AddUniqueConstraint addUniqueConstraint(String tableName) {
        AddUniqueConstraint create = new AddUniqueConstraint();
        create.setConstraintName(this.getName());
        create.setTableName(tableName);
        create.setColumnNames(this.join(this.columns));
        create.setNullableColumns(this.join(this.nullableColumns));
        create.setOneToOne(this.isOneToOne());
        create.setPlatforms(this.platforms);
        return create;
    }

    public AddUniqueConstraint dropUniqueConstraint(String tableName) {
        AddUniqueConstraint drop = new AddUniqueConstraint();
        drop.setConstraintName(this.name);
        drop.setTableName(tableName);
        drop.setColumnNames("DROP CONSTRAINT");
        drop.setNullableColumns(this.join(this.nullableColumns));
        drop.setPlatforms(this.platforms);
        return drop;
    }

    public void setNullableColumns(String[] nullableColumns) {
        this.nullableColumns = nullableColumns != null && nullableColumns.length == 0 ? null : nullableColumns;
    }

    private String join(String[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.columns) + 31 * Objects.hash(this.name, this.oneToOne);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MCompoundUniqueConstraint)) {
            return false;
        }
        MCompoundUniqueConstraint other = (MCompoundUniqueConstraint)obj;
        return this.oneToOne == other.oneToOne && Objects.equals(this.name, other.name) && Arrays.equals(this.columns, other.columns) && Arrays.equals(this.nullableColumns, other.nullableColumns);
    }
}

