/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.migration.MigrationVersion;
import io.ebeaninternal.dbmigration.model.MigrationResource;
import io.ebeaninternal.dbmigration.model.ModelContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationModel {
    private static final Logger logger = LoggerFactory.getLogger(MigrationModel.class);
    private final ModelContainer model = new ModelContainer();
    private final File modelDirectory;
    private final String modelSuffix;
    private MigrationVersion lastVersion;

    public MigrationModel(File modelDirectory, String modelSuffix) {
        this.modelDirectory = modelDirectory;
        this.modelSuffix = modelSuffix;
    }

    public ModelContainer read(boolean dbinitMigration) {
        this.readMigrations(dbinitMigration);
        return this.model;
    }

    private void readMigrations(boolean dbinitMigration) {
        File[] xmlFiles = this.modelDirectory.listFiles(pathname -> pathname.getName().toLowerCase().endsWith(this.modelSuffix));
        if (xmlFiles == null || xmlFiles.length == 0) {
            return;
        }
        ArrayList<MigrationResource> resources = new ArrayList<MigrationResource>(xmlFiles.length);
        for (File xmlFile : xmlFiles) {
            resources.add(new MigrationResource(xmlFile, this.createVersion(xmlFile)));
        }
        Collections.sort(resources);
        if (!dbinitMigration) {
            for (MigrationResource migrationResource : resources) {
                logger.debug("read {}", (Object)migrationResource);
                this.model.apply(migrationResource.read(), migrationResource.getVersion());
            }
        }
        if (!resources.isEmpty()) {
            this.lastVersion = ((MigrationResource)resources.get(resources.size() - 1)).getVersion();
        }
    }

    private MigrationVersion createVersion(File xmlFile) {
        String fileName = xmlFile.getName();
        String versionName = fileName.substring(0, fileName.length() - this.modelSuffix.length());
        return MigrationVersion.parse((String)versionName);
    }

    public String getNextVersion(String initialVersion) {
        return this.lastVersion == null ? initialVersion : this.lastVersion.nextVersion();
    }
}

