/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.platform.SplitColumns;
import io.ebeaninternal.dbmigration.migration.CreateIndex;

class WriteCreateIndex {
    private final String indexName;
    private final String tableName;
    private final String[] columns;
    private final boolean unique;
    private final boolean concurrent;
    private final String definition;
    private final boolean notExistsCheck;

    WriteCreateIndex(String indexName, String tableName, String[] columns, boolean unique) {
        this.indexName = indexName;
        this.tableName = tableName;
        this.columns = columns;
        this.unique = unique;
        this.concurrent = false;
        this.definition = null;
        this.notExistsCheck = false;
    }

    public WriteCreateIndex(CreateIndex index) {
        this.indexName = index.getIndexName();
        this.tableName = index.getTableName();
        this.columns = SplitColumns.split(index.getColumns());
        this.unique = Boolean.TRUE.equals(index.isUnique());
        this.concurrent = Boolean.TRUE.equals(index.isConcurrent());
        this.definition = index.getDefinition();
        this.notExistsCheck = true;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public String getDefinition() {
        return this.definition;
    }

    public boolean useDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public boolean isNotExistsCheck() {
        return this.notExistsCheck;
    }
}

