/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MTable;
import java.io.IOException;

public class SqlServerHistoryDdl
implements PlatformHistoryDdl {
    private String systemPeriodStart;
    private String systemPeriodEnd;
    private PlatformDdl platformDdl;

    @Override
    public void configure(DatabaseConfig config, PlatformDdl platformDdl) {
        this.systemPeriodStart = config.getAsOfSysPeriod() + "From";
        this.systemPeriodEnd = config.getAsOfSysPeriod() + "To";
        this.platformDdl = platformDdl;
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) throws IOException {
        String baseTable = table.getName();
        this.enableSystemVersioning(writer, baseTable);
    }

    String getHistoryTable(String baseTable) {
        String historyTable = baseTable + "_history";
        if (baseTable.startsWith("[")) {
            historyTable = historyTable.replace("]", "") + "]";
        }
        if (historyTable.indexOf(46) == -1) {
            historyTable = "dbo." + historyTable;
        }
        return historyTable;
    }

    private void enableSystemVersioning(DdlWrite writer, String baseTable) throws IOException {
        DdlBuffer apply = writer.applyHistoryView();
        apply.append("alter table ").append(baseTable).newLine().append("    add ").append(this.systemPeriodStart).append(" datetime2 GENERATED ALWAYS AS ROW START NOT NULL DEFAULT SYSUTCDATETIME(),").newLine().append("        ").append(this.systemPeriodEnd).append("   datetime2 GENERATED ALWAYS AS ROW END   NOT NULL DEFAULT '9999-12-31T23:59:59.9999999',").newLine().append("period for system_time (").append(this.systemPeriodStart).append(", ").append(this.systemPeriodEnd).append(")").endOfStatement();
        apply.append("alter table ").append(baseTable).append(" set (system_versioning = on (history_table=").append(this.getHistoryTable(baseTable)).append("))").endOfStatement();
        DdlBuffer drop = writer.dropAll();
        drop.append("IF OBJECT_ID('").append(baseTable).append("', 'U') IS NOT NULL alter table ").append(baseTable).append(" set (system_versioning = off)").endOfStatement();
        drop.append("IF OBJECT_ID('").append(baseTable).append("_history', 'U') IS NOT NULL drop table ").append(baseTable).append("_history").endOfStatement();
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        String baseTable = dropHistoryTable.getBaseTable();
        DdlBuffer apply = writer.applyHistoryView();
        apply.append("-- dropping history support for ").append(baseTable).endOfStatement();
        apply.append(this.platformDdl.alterColumnDefaultValue(baseTable, this.systemPeriodStart, "DROP DEFAULT")).endOfStatement();
        apply.append(this.platformDdl.alterColumnDefaultValue(baseTable, this.systemPeriodEnd, "DROP DEFAULT")).endOfStatement();
        apply.append("alter table ").append(baseTable).append(" set (system_versioning = off)").endOfStatement();
        apply.append("alter table ").append(baseTable).append(" drop period for system_time").endOfStatement();
        apply.append("alter table ").append(baseTable).append(" drop column ").append(this.systemPeriodStart).endOfStatement();
        apply.append("alter table ").append(baseTable).append(" drop column ").append(this.systemPeriodEnd).endOfStatement();
        apply.append("IF OBJECT_ID('").append(baseTable).append("_history', 'U') IS NOT NULL drop table ").append(baseTable).append("_history").endOfStatement();
        apply.end();
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        String baseTable = addHistoryTable.getBaseTable();
        this.enableSystemVersioning(writer, baseTable);
    }

    @Override
    public void updateTriggers(DdlWrite writer, HistoryTableUpdate baseTable) throws IOException {
        DdlBuffer apply = writer.applyHistoryView();
        String baseTableName = baseTable.getBaseTable();
        apply.append("-- alter table ").append(baseTableName).append(" set (system_versioning = off (history_table=").append(this.getHistoryTable(baseTableName)).append("))").endOfStatement();
        apply.append("-- history migration goes here").newLine();
        apply.append("-- alter table ").append(baseTableName).append(" set (system_versioning = on (history_table=").append(this.getHistoryTable(baseTableName)).append("))").endOfStatement();
    }
}

