/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseDdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HanaDdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HanaHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractHanaDdl
extends PlatformDdl {
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(\\w+)\\s*\\[\\s*\\]\\s*(\\(\\d+\\))?", 2);

    public AbstractHanaDdl(DatabasePlatform platform) {
        super(platform);
        this.addColumn = "add (";
        this.addColumnSuffix = ")";
        this.alterColumn = "alter (";
        this.alterColumnSuffix = ")";
        this.columnDropDefault = " default null";
        this.columnSetDefault = " default";
        this.columnSetNotnull = " not null";
        this.columnSetNull = " null";
        this.dropColumn = "drop (";
        this.dropColumnSuffix = ")";
        this.dropConstraintIfExists = "drop constraint ";
        this.dropIndexIfExists = "drop index ";
        this.dropSequenceIfExists = "drop sequence ";
        this.dropTableCascade = " cascade";
        this.dropTableIfExists = "drop table ";
        this.fallbackArrayType = "nvarchar(1000)";
        this.historyDdl = new HanaHistoryDdl();
        this.identitySuffix = " generated by default as identity";
    }

    @Override
    public String alterColumnBaseAttributes(AlterColumn alter) {
        String notnullClause;
        String tableName = alter.getTableName();
        String columnName = alter.getColumnName();
        String currentType = alter.getCurrentType();
        String type = alter.getType() != null ? alter.getType() : currentType;
        type = this.convert(type);
        currentType = this.convert(currentType);
        boolean notnull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isCurrentNotnull());
        String string = notnullClause = notnull ? " not null" : "";
        String defaultValue = DdlHelp.isDropDefault(alter.getDefaultValue()) ? "null" : (alter.getDefaultValue() != null ? alter.getDefaultValue() : alter.getCurrentDefaultValue());
        String defaultValueClause = defaultValue == null || defaultValue.isEmpty() ? "" : " default " + defaultValue;
        try {
            BaseDdlBuffer buffer = new BaseDdlBuffer(null);
            if (!this.isConvertible(currentType, type)) {
                if (this.isNumberType(currentType)) {
                    buffer.append("alter table ").append(tableName).append(" ").append(this.alterColumn).append(" ").append(columnName).append(" decimal ").append(defaultValueClause).append(notnullClause).append(this.alterColumnSuffix).endOfStatement();
                } else if (this.isStringType(currentType)) {
                    buffer.append("alter table ").append(tableName).append(" ").append(this.alterColumn).append(" ").append(columnName).append(" nclob ").append(defaultValueClause).append(notnullClause).append(this.alterColumnSuffix).endOfStatement();
                }
            }
            buffer.append("alter table ").append(tableName).append(" ").append(this.alterColumn).append(" ").append(columnName).append(" ").append(type).append(defaultValueClause).append(notnullClause).append(this.alterColumnSuffix);
            return buffer.getBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String alterColumnDefaultValue(String tableName, String columnName, String defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String alterColumnNotnull(String tableName, String columnName, boolean notnull) {
        return null;
    }

    @Override
    public DdlHandler createDdlHandler(DatabaseConfig config) {
        return new HanaDdlHandler(config, this);
    }

    @Override
    public String alterColumnType(String tableName, String columnName, String type) {
        return null;
    }

    @Override
    protected String convertArrayType(String logicalArrayType) {
        Matcher matcher = ARRAY_PATTERN.matcher(logicalArrayType);
        if (matcher.matches()) {
            return this.convert(matcher.group(1)) + " array" + (matcher.group(2) == null ? "" : matcher.group(2));
        }
        return this.fallbackArrayType;
    }

    @Override
    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        if (nullableColumns == null || nullableColumns.length == 0) {
            return super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
        }
        return "-- cannot create unique index \"" + uqName + "\" on table \"" + tableName + "\" with nullable columns";
    }

    @Override
    public String alterTableDropUniqueConstraint(String tableName, String uniqueConstraintName) {
        BaseDdlBuffer buffer = new BaseDdlBuffer(null);
        try {
            buffer.append("delimiter $$").newLine();
            buffer.append("do").newLine();
            buffer.append("begin").newLine();
            buffer.append("declare exit handler for sql_error_code 397 begin end").endOfStatement();
            buffer.append("exec 'alter table ").append(tableName).append(" ").append(this.dropUniqueConstraint).append(" ").append(this.maxConstraintName(uniqueConstraintName)).append("'").endOfStatement();
            buffer.append("end").endOfStatement();
            buffer.append("$$");
            return buffer.getBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String alterTableDropConstraint(String tableName, String constraintName) {
        return this.alterTableDropUniqueConstraint(tableName, constraintName);
    }

    @Override
    public void alterTableDropColumn(DdlBuffer buffer, String tableName, String columnName) throws IOException {
        buffer.append("CALL usp_ebean_drop_column('").append(tableName).append("', '").append(columnName).append("')").endOfStatement();
    }

    private boolean isConvertible(String sourceType, String targetType) {
        DbPlatformType dbPlatformTargetType;
        if (Objects.equals(sourceType, targetType)) {
            return true;
        }
        if (sourceType == null || targetType == null) {
            return true;
        }
        if ("bigint".equals(sourceType) ? "integer".equals(targetType) || "smallint".equals(targetType) || "tinyint".equals(targetType) : ("integer".equals(sourceType) ? "smallint".equals(targetType) || "tinyint".equals(targetType) : ("smallint".equals(sourceType) ? "tinyint".equals(targetType) : "double".equals(sourceType) && "real".equals(targetType)))) {
            return false;
        }
        DbPlatformType dbPlatformSourceType = DbPlatformType.parse((String)sourceType);
        return !("float".equals(dbPlatformSourceType.getName()) ? "real".equals(targetType) : ("varchar".equals(dbPlatformSourceType.getName()) || "nvarchar".equals(dbPlatformSourceType.getName()) ? ("varchar".equals((dbPlatformTargetType = DbPlatformType.parse((String)targetType)).getName()) || "nvarchar".equals(dbPlatformTargetType.getName())) && dbPlatformSourceType.getDefaultLength() > dbPlatformTargetType.getDefaultLength() : "decimal".equals(dbPlatformSourceType.getName()) && "decimal".equals((dbPlatformTargetType = DbPlatformType.parse((String)targetType)).getName()) && (dbPlatformSourceType.getDefaultLength() > dbPlatformTargetType.getDefaultLength() || dbPlatformSourceType.getDefaultScale() > dbPlatformTargetType.getDefaultScale())));
    }

    private boolean isNumberType(String type) {
        return type != null && ("bigint".equals(type) || "integer".equals(type) || "smallint".equals(type) || "tinyint".equals(type) || type.startsWith("float") || "real".equals(type) || "double".equals(type) || type.startsWith("decimal"));
    }

    private boolean isStringType(String type) {
        return type != null && (type.startsWith("varchar") || type.startsWith("nvarchar") || "clob".equals(type) || "nclob".equals(type));
    }
}

