/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;

class MChecksum {
    MChecksum() {
    }

    static int calculate(File file) {
        try {
            String line;
            CRC32 crc32 = new CRC32();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((line = bufferedReader.readLine()) != null) {
                byte[] lineBytes = line.getBytes(StandardCharsets.UTF_8);
                crc32.update(lineBytes, 0, lineBytes.length);
            }
            return (int)crc32.getValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to calculate checksum", e);
        }
    }
}

